import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;



class Bord extends AnchorPane
{
	static int veldBreedte = 60;

	Lingo lingo;
	int aantLetters;
	BordVeld[][] velden;

	TextField tfRaadWoord;
	Button btnRaad;



	Bord(Lingo lingo, int aantLetters)
	{
		this.lingo = lingo;
		this.aantLetters = aantLetters;
		velden = new BordVeld[5][aantLetters];
		for (int rij = 0; rij < 5; rij++)
			for (int kol = 0; kol < aantLetters; kol++)
			{
				BordVeld veld = new BordVeld();
				AnchorPane.setLeftAnchor(veld, 0.0 + kol * veldBreedte);
				AnchorPane.setTopAnchor(veld, 0.0 + rij * veldBreedte);
				super.getChildren().add(veld);
				velden[rij][kol] = veld;
			}

		tfRaadWoord = new TextField("");
		tfRaadWoord.setMaxWidth(100);
		AnchorPane.setLeftAnchor(tfRaadWoord, 0.0);
		AnchorPane.setTopAnchor(tfRaadWoord, 5 * veldBreedte + 20.0);
		super.getChildren().add(tfRaadWoord);
		
		btnRaad = new Button("Raad");
		AnchorPane.setLeftAnchor(btnRaad, 120.0);
		AnchorPane.setTopAnchor(btnRaad, 5 * veldBreedte + 20.0);
		super.getChildren().add(btnRaad);
		
		btnRaad.setOnAction(new EventHandler<ActionEvent>() {
			@Override public void handle(ActionEvent e) 
			{
				lingo.raad();
			}
		});
				
	}



	void maakLeeg()
	{
		for (int rij = 0; rij < 5; rij++)
			for (int kol = 0; kol < aantLetters; kol++)
				velden[rij][kol].setStatus(BordVeld.LEEG);
	}


 
}