import java.io.*;



class HighScores
{
	int aantEntries;
	int[] scores;


	HighScores()
	{
		this(10);
	}


	
	HighScores(int aantEntries)
	{
		this.aantEntries = aantEntries;
		scores = new int[aantEntries]; 
	}



	void load()
	{
		try
		{
			FileInputStream fis = new FileInputStream("highscores");
    			DataInputStream in = new DataInputStream(new BufferedInputStream(fis));
			aantEntries = in.readInt();
			scores = new int[aantEntries];
			for (int i = 0; i < aantEntries; i++)
				scores[i] = in.readInt();
			in.close();
    		}
		catch (IOException ioExc)
		{	
		}
	}
	
	

	void save()
	{
		try 
		{
			FileOutputStream fos = new FileOutputStream("highscores");
			DataOutputStream out = new DataOutputStream(new BufferedOutputStream(fos));
			out.writeInt(aantEntries);
			for (int i = 0; i < aantEntries; i++)
				out.writeInt(scores[i]);
			out.close();			
		}
		catch (IOException ioExc)
		{	
		}
	}
	


	void addScore(int score)
	{
		for (int entry = 0; entry < aantEntries; entry++)
			if (score > scores[entry])
			{
				for (int i = aantEntries - 1; i > entry; i--)
					scores[i] = scores[i - 1];
				scores[entry] = score;
				break;
			}
	}



	void print()
	{
		System.out.println("HIGHSCORES");
		System.out.println();
		for (int entry = 0; entry < aantEntries; entry++)
		{
			System.out.printf("%10d", scores[entry]);
			System.out.println();
		}
	}



}