import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;



class Kaart extends AnchorPane
{
	static int veldBreedte = 60;

	KaartVeld[][] velden;
	boolean even;
	boolean finale;
	


	Kaart(boolean even)
	{
		this.even = even;

		Rectangle achtergrond = new Rectangle(5 * veldBreedte, 5 * veldBreedte);
		achtergrond.setFill(Color.DARKGREY);
		super.getChildren().add(achtergrond);

		velden = new KaartVeld[5][5];
		for (int kol = 0; kol < 5; kol++)
			for (int rij = 0; rij < 5; rij++)		
			{
				KaartVeld veld = new KaartVeld(rij, kol);
				AnchorPane.setLeftAnchor(veld, 0.0 + kol * veldBreedte);
				AnchorPane.setTopAnchor(veld, 0.0 + rij * veldBreedte);
				super.getChildren().add(veld);
				velden[kol][rij] = veld;
			}
 
	}



	void nieuweKaart(boolean finale)
	{
		this.finale = finale;
		for (int kol = 0; kol < 5; kol++)
			for (int rij = 0; rij < 5; rij++)		
				velden[kol][rij].reset();		
		setNummers();
		streepNummersWeg();
	}



	void setNummers()
	{
		for (int kol = 0; kol < 5; kol++)
			for (int rij = 0; rij < 5; rij++)		
			{
				int nummer = 0;
				if (finale && kol == 2 && rij == 2)  //middelste veld
				{
					if (even)
						nummer = 42;
					else
						nummer = 33;	
				}
				else 
					nummerTrekken:
					while (true)  //trek net zolang een willekeurig nummer, totdat een geschikt nummer is gevonden
					{
						nummer =  14 * kol + 2 * (int)(Math.random() * 7);
						nummer += (even ? 2 : 1);
						if (finale && kol == 2 && (nummer == 42 || nummer == 33))
							continue;
						for (int r = 0; r < rij; r++)
							if (nummer == velden[kol][r].nummer) //nummer bestaat al in deze kaart(kolom)
								continue nummerTrekken;
						break;
					}		

				velden[kol][rij].setNummer(nummer);
			}
		
	}



	void streepNummersWeg()
	{
		boolean[][] nummersWeg = null;
		if (finale)
			nummersWeg = new boolean[][]{
				{true, false, true, false, true},
				{false, true, true, true, false},
				{true, true, false, true, true},
				{false, true, true, true, false},
				{true, false, true, false, true}
			};
		else
			nummersWeg = new boolean[][]{
				{true, false, false, false, true},
				{false, false, true, true, false},
				{false, true, false, false, false},
				{true, false, false, false, true},
				{false, false, true, false, false}
			};
	
		for (int kol = 0; kol < 5; kol++)
			for (int rij = 0; rij < 5; rij++)
				if (nummersWeg[kol][rij])
				{
					velden[kol][rij].streepNummerWeg();
				}	

	}
		

	
	void streepNummerWeg(int nummer)
	{
		for (int kol = 0; kol < 5; kol++)
			for (int rij = 0; rij < 5; rij++)
				if (nummer == velden[kol][rij].nummer)
					velden[kol][rij].streepNummerWeg();
	}


	
	boolean lingo()
	{
		for (int kol = 0; kol < 5; kol++)
			if (velden[kol][0].weggestreept && velden[kol][1].weggestreept && velden[kol][2].weggestreept &&
			    velden[kol][3].weggestreept && velden[kol][4].weggestreept)
				return true;

		for (int rij = 0; rij < 5; rij++)
			if (velden[0][rij].weggestreept && velden[1][rij].weggestreept && velden[2][rij].weggestreept &&
			    velden[3][rij].weggestreept && velden[4][rij].weggestreept)
				return true;		

		if (velden[0][0].weggestreept && velden[1][1].weggestreept && velden[2][2].weggestreept &&
		    velden[3][3].weggestreept && velden[4][4].weggestreept)
			return true;

		if (velden[0][4].weggestreept && velden[1][3].weggestreept && velden[2][2].weggestreept &&
		    velden[3][1].weggestreept && velden[4][0].weggestreept)
			return true;

		return false;	
	}



}