import javafx.scene.control.Alert;
import javafx.scene.control.Alert.AlertType;
import javafx.scene.control.ButtonType;
import java.util.Optional;


class HumanSpeler extends Speler
{

	HumanSpeler(MP mp, int nummer, String letter, Veld veld)
	{
		super(mp, nummer, letter, veld);
	}



	boolean wantsToBuyStreet(Straat straat)
	{	
		String message = straat.naam + " is te koop. De straat kost " + straat.prijs + ",-. " +
			"U heeft " + saldo + ",- in kas. " + 
			"Wilt u deze straat kopen? ";

		Alert alert = new Alert(AlertType.CONFIRMATION, message);
		Optional<ButtonType> result = alert.showAndWait();
 		return (result.isPresent() && result.get() == ButtonType.OK);		
	}



	boolean accepteertBod(Straat gewensteStraat, Speler bieder, int biedPrijs)
	{
		String message = letter + ", accepteert u een bod van " + bieder.letter + 
			" op " + gewensteStraat.naam + " voor " + biedPrijs + ",- ?";
		
		Alert alert = new Alert(AlertType.CONFIRMATION, message);
		Optional<ButtonType> result = alert.showAndWait();
 		return (result.isPresent() && result.get() == ButtonType.OK);
	}
}