import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextInputDialog;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.stage.Stage;

//nodig voor confirmation dialog
import javafx.scene.control.Alert;
import javafx.scene.control.Alert.AlertType;
import javafx.scene.control.ButtonType;
import java.util.Optional;



public class MP extends Application 
{
	Stad[] steden;
	GridPane bord;
	Veld[] velden;
	Speler[] spelers;
	Speler spelerADB;
	int aanDeBeurtInd = 0;
	int[] dobs = new int[2];
	AnchorPane rootPane;	
	TextArea textAreaLog;
	Text txtADB;
	Button btnBied;
	Button btnKoopHuis;
 


	@Override
	public void start(Stage stage) throws Exception {


		rootPane = new AnchorPane();

		bord = new GridPane();

		velden = new Veld[40];

			steden = new Stad[] {             //de straten(=velden) worden hier ook gecreeerd
	
			                        //veld-indices         //straat-prijzen
			new Stad(this, 0, "od", Color.PURPLE, new int[]{1, 3},       new int[]{60, 60}),       
			new Stad(this, 1, "ar", Color.LIGHTBLUE, new int[]{6, 8 ,9},    new int[]{100, 100, 120}),
			new Stad(this, 2, "ha", Color.PINK, new int[]{11, 13, 14}, new int[]{140, 140, 160}), 
			new Stad(this, 3, "ut", Color.ORANGE, new int[]{16, 18, 19}, new int[]{180, 180, 200}),
			new Stad(this, 4 ,"gr", Color.RED, new int[]{21, 23, 24}, new int[]{220, 220, 240}),
			new Stad(this, 5, "dh", Color.YELLOW, new int[]{26, 27, 29}, new int[]{260, 260, 280}),
			new Stad(this, 6, "rd", Color.GREEN, new int[]{31, 32, 34}, new int[]{300, 300, 320}),
			new Stad(this, 7, "ad", Color.BLUE, new int[]{37, 39},     new int[]{350, 400}) };

		//creeer de overige velden
		for (int v = 0; v < 40; v++)
			if (velden[v] == null)
			{
				velden[v] = new Veld(this, v, null);
				//bord.add(velden[v], v % 10, v / 10);		
			}
	
		//bord.setPrefSize(1000.0, 600.0);
	


		int aantHumanSpelers = 1, aantCompSpelers = 3; 

		spelers = new Speler[aantHumanSpelers + aantCompSpelers];
		int ind = 0;
		for (int i = 0; i < aantHumanSpelers; i++)
		{
			String strLetter = new String(new char[]{(char)('A' + ind)});
			spelers[ind] = new HumanSpeler(this, ind, strLetter, velden[0]);
			ind++;
		}
		for (int i = 0; i < aantCompSpelers; i++)
		{
			String strLetter = new String(new char[]{(char)('A' + ind)});
			spelers[ind] = new CompSpeler(this, ind, strLetter, velden[0]);
			ind++;
		}	   

		for (int sp = 0; sp < spelers.length; sp++)
			spelers[sp].saldo = 1500;

	
		
		rootPane.getChildren().add(bord);
		AnchorPane.setLeftAnchor(bord, 50.0);
		AnchorPane.setTopAnchor(bord, 50.0);

		textAreaLog = new TextArea();
		textAreaLog.setEditable(false);
		textAreaLog.setFont(new Font(14));
		AnchorPane.setLeftAnchor(textAreaLog, 50.0);
		AnchorPane.setTopAnchor(textAreaLog, 560.0);
		textAreaLog.setPrefSize(800.0, 100.0);

		rootPane.getChildren().add(textAreaLog);
		
		txtADB = new Text("");
		txtADB.setFont(new Font(15));
		AnchorPane.setLeftAnchor(txtADB, 900.0);
		AnchorPane.setTopAnchor(txtADB, 560.0);
		rootPane.getChildren().add(txtADB);

		Button btnContinue = new Button("Volgende");
		AnchorPane.setLeftAnchor(btnContinue, 900.0);
		AnchorPane.setTopAnchor(btnContinue, 600.0);
		rootPane.getChildren().add(btnContinue);
		
		btnBied = new Button("Bied op straat van medespeler");
		AnchorPane.setLeftAnchor(btnBied, 1100.0);
		AnchorPane.setTopAnchor(btnBied, 600.0);
		rootPane.getChildren().add(btnBied);
		btnBied.setDisable(true);
		
		btnKoopHuis = new Button("Koop een huis");
		AnchorPane.setLeftAnchor(btnKoopHuis, 1100.0);
		AnchorPane.setTopAnchor(btnKoopHuis, 650.0);
		rootPane.getChildren().add(btnKoopHuis);
		btnKoopHuis.setDisable(true);
		
		aanDeBeurtInd = spelers.length - 1;

		btnContinue.setOnAction(new EventHandler<ActionEvent>() {
			@Override public void handle(ActionEvent e) {
				if (aanDeBeurtInd == spelers.length - 1)
					aanDeBeurtInd = 0; 
				else
					aanDeBeurtInd += 1;
      
	  			spelerADB = spelers[aanDeBeurtInd];
				println(spelerADB.letter + " is aan de beurt.");
				txtADB.setText("Aan de beurt:    speler " + spelerADB.letter);
				
				btnBied.setDisable(spelerADB instanceof CompSpeler);
				btnKoopHuis.setDisable(spelerADB instanceof CompSpeler);
				
	

				if (spelerADB instanceof HumanSpeler)
				{
					String message = "Speler " + spelerADB.letter + ", druk op OK om te gooien";
					(new Alert(AlertType.INFORMATION, message)).showAndWait();
				}
	
				dobs[0] = (int)(6 * Math.random() + 1);
				dobs[1] = (int)(6 * Math.random() + 1);
				int somOgen = dobs[0] + dobs[1];
				int newVeldNr = spelerADB.veld.nummer + somOgen;
				if (newVeldNr >= 40)
				{
					newVeldNr -= 40;
					if (newVeldNr == 0)
						spelerADB.setSaldo(spelerADB.saldo + 400);
					else
						spelerADB.setSaldo(spelerADB.saldo + 200);
				}	
				spelerADB.setVeld(velden[newVeldNr]);
		
				println(spelerADB.letter + " gooit: " + dobs[0] + " en " + dobs[1]);
				println(spelerADB.letter + " belandt op " + spelerADB.veld.naam);
			
				if (spelerADB.veld instanceof Straat)
				{
					Straat straat = (Straat) spelerADB.veld; 
					if (straat.eigenaar == null)
					{
						//spelerADB kan de straat kopen
						if (spelerADB.saldo >= straat.prijs && spelerADB.wantsToBuyStreet(straat)) 
						{
							spelerADB.setSaldo(spelerADB.saldo - straat.prijs); 
							straat.setEigenaar(spelerADB);
							println(spelerADB.letter + " koopt " + straat.naam);				
						}
						
					}
					else
					{
						if (spelerADB.nummer != straat.eigenaar.nummer)		
						{	
							//spelerADB moet bezoekTarief betalen aan de eigenaar			
							int bezoekTarief = straat.getTarief();
							spelerADB.setSaldo(spelerADB.saldo - bezoekTarief);	
							straat.eigenaar.setSaldo(straat.eigenaar.saldo + bezoekTarief); //kan eigenlijk niet als spelerADB failliet is
							println(spelerADB.letter + " betaalt " + bezoekTarief + 
								",- bezoek-tarief aan " + straat.eigenaar.letter + ".");
						}
					}
				}

				if (spelerADB instanceof CompSpeler)
				{	
					CompSpeler compSpeler = (CompSpeler) spelerADB; 
					compSpeler.biedOpStraten_buyHouses();
				}

				if (spelerADB.saldo < 0) 
				{
					alert("SPELER " + spelerADB.letter + " IS FAILLIET en wordt uit het spel verwijderd.");
					
					spelerADB.setVeld(null);

					btnBied.setDisable(true);
					btnKoopHuis.setDisable(true);
					
					//de straten van de failliete speler komen weer in het spel
					for (Straat str : spelerADB.getStraten())
					{
						str.setEigenaar(null);
						str.setAantHuizen(0);

						//de computer-spelers moeten (later, bij medespelers) weer kunnen bieden op de failliete straten
						for (Speler speler : spelers)
							if (speler instanceof CompSpeler) 
								((CompSpeler)speler).gebodenOpStraat[str.nummer] = false;		
					}

					//removeSpeler
					Speler[] newSpelers = new Speler[spelers.length - 1];
					for (int i = 0; i < aanDeBeurtInd; i++)
						newSpelers[i] = spelers[i];
					for (int i = aanDeBeurtInd; i < newSpelers.length; i++)
					{
						newSpelers[i] = spelers[i + 1];
						newSpelers[i].nummer = i;	//riskant om de nummers van de Spelers te veranderen
					}
					spelers = newSpelers;
	
					// NB goed opletten wat de NIEUWE index wordt van aanDeBeurt 
					if (aanDeBeurtInd == 0)
						aanDeBeurtInd = spelers.length - 1;
					else
						aanDeBeurtInd -= 1;   //word weer opgehoogd als op "Volgende" wordt gedrukt
						
					
	
				}
    			}
		});


		
		btnBied.setOnAction(new EventHandler<ActionEvent>() {
			@Override public void handle(ActionEvent e) 
			{
				String straatNaam = inputDialog("Op welke straat wilt u bieden?");				
				Straat gewensteStraat = getStraat(straatNaam);
				if (gewensteStraat == null)  { alert("Onbekende straat."); return; }
				if (gewensteStraat.eigenaar == null) { alert("Deze straat is van niemand."); return; }
				if (gewensteStraat.eigenaar.nummer == spelerADB.nummer) { alert("U bezit deze straat al."); return; }
				if (gewensteStraat.aantHuizen > 0) { alert("U kunt niet bieden op een straat met huizen."); return; }
				//later toevoegen?? wat als de speler op een complete STAD wil bieden? of op 2 straten tegelijk

				int prijs = 0;
				String strPrijs = inputDialog("Biedprijs:");
				try { prijs = Integer.parseInt(strPrijs); } catch (NumberFormatException nfExc) { return; } 
				
				if (prijs < 0) return;
				if (prijs > spelerADB.saldo) { alert("U hebt onvoldoende saldo voor dit bod."); return; }

				verwerkBod(gewensteStraat, prijs);
			}
		});




		btnKoopHuis.setOnAction(new EventHandler<ActionEvent>() {
			@Override public void handle(ActionEvent e) 
			{
				String stadNaam = inputDialog("In welke (2-letterige) stad wilt u een huis kopen?");
				Stad stad = getStad(stadNaam);
				if (stad == null)  { alert("Onbekende stad."); return; }
				if (!(spelerADB.ownsCity(stad))) { alert("U bezit niet alle straten van deze stad."); return; }
				if (stad.straten[0].huizenPrijs > spelerADB.saldo) { alert("Onvoldoende saldo."); return; }
				if (stad.straten[stad.straten.length - 1].aantHuizen == 4) { alert("Deze stad is vol."); return; }
				verwerkHuizenKoop(stad);
			}
		});



		Scene scene = new Scene(rootPane, 1300, 750);
		stage.setTitle("MP GUI");
		stage.setScene(scene);
		stage.show();

	}



	public static void main(String[] args) 
	{
		launch(args);
	}




	void print(String str)
	{
		textAreaLog.appendText(str);
	}



	void println(String str)
	{
		textAreaLog.appendText(str + "\n");	
	}



	void println()
	{
		textAreaLog.appendText("\n"); 
	}


/*
	String readln()
	{
		return "";
		//return System.console().readLine();
	}
*/



	void alert(String message)
	{
		(new Alert(AlertType.INFORMATION, message)).showAndWait();
	}



	String inputDialog(String message) 	
	{
		TextInputDialog dialog = new TextInputDialog("");
		dialog.setContentText(message);
 		dialog.showAndWait();
		return dialog.getEditor().getText(); 
	}



	void verwerkBod(Straat gewensteStraat, int prijs) 
	{
		//de bieder moet wel aan de beurt zijn   (bieder = spelerADB)

		println(spelerADB.letter + " doet een bod van " + prijs + ",- op " + gewensteStraat.naam + 
			" van speler " + gewensteStraat.eigenaar.letter + ".");

		boolean akkoord = gewensteStraat.eigenaar.accepteertBod(gewensteStraat, spelerADB, prijs);
		if (akkoord)
		{
			println(gewensteStraat.eigenaar.letter + " heeft het bod geaccepteerd. " +
				gewensteStraat.naam + " is nu van " + spelerADB.letter + ".");				
			spelerADB.setSaldo(spelerADB.saldo - prijs);
			gewensteStraat.eigenaar.setSaldo(gewensteStraat.eigenaar.saldo + prijs); 
			gewensteStraat.setEigenaar(spelerADB);	
		}
		else
		{
			println(gewensteStraat.eigenaar.letter + " heeft het bod afgewezen.");
		}

	}



	void verwerkHuizenKoop(Stad stad)
	{
		//voeg huis toe aan de straat waar nu het minste aantal huizen staan
		Straat straat = stad.straten[0];
		for (int i = 1; i < stad.straten.length; i++)
			if (stad.straten[i].aantHuizen < straat.aantHuizen)
				straat = stad.straten[i];
		
		spelerADB.setSaldo(spelerADB.saldo - straat.huizenPrijs);
		straat.setAantHuizen(straat.aantHuizen + 1);			

		println(spelerADB.letter + " koopt een huis op " + straat.naam + ".");
	}


	
	Straat getStraat(String straatNaam)
	{
		for (int i = 0; i < steden.length; i++)
			for (Straat straat : steden[i].straten)
				if (straat.naam.equals(straatNaam))
					return straat;
		return null;
	}



	Stad getStad(String stadNaam)
	{
		for (int i = 0; i < steden.length; i++)
			if (steden[i].naam.equals(stadNaam))
				return steden[i];
		return null;
	}



}