import java.util.*;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;



abstract class Speler extends AnchorPane
{
	//max 4 spelers
	static Color[] bgColors = new Color[]{Color.LIGHTGREEN, Color.LIGHTPINK, Color.LIGHTBLUE, Color.LIGHTGRAY};
	MP mp;
	int nummer;
	String letter;
	Veld veld;
	int saldo;  //hoeveel geld heeft de speler
	Color kleur;
	Text txtNaam, txtSaldo;



	Speler(MP mp, int nummer, String letter, Veld veld)
	{
		super();
		Text text = new Text(letter);
		text.setFont(new Font("Arial Bold", 15));
		AnchorPane.setTopAnchor(text, 100.0);
		AnchorPane.setLeftAnchor(text, 15.0 + 15 * nummer); 
		super.getChildren().add(text);

		this.mp = mp;
		this.nummer = nummer;
		this.letter = letter;
		setVeld(veld);
		
		this.kleur = bgColors[nummer];
		
		Rectangle rectKleur = new Rectangle(20, 20);
		rectKleur.setFill(this.kleur);
		AnchorPane.setLeftAnchor(rectKleur, 920.0);  
		AnchorPane.setTopAnchor(rectKleur, 100.0 + 25 * nummer);
		mp.rootPane.getChildren().add(rectKleur);

		txtNaam = new Text("Speler " + letter);
		//txtNaam.setFill(bgColors[nummer]);
		AnchorPane.setLeftAnchor(txtNaam, 950.0);  
		AnchorPane.setTopAnchor(txtNaam, 100.0 + 25 * nummer);
		mp.rootPane.getChildren().add(txtNaam);
		
		txtSaldo = new Text("");
		AnchorPane.setLeftAnchor(txtSaldo, 1050.0);  
		AnchorPane.setTopAnchor(txtSaldo, 100.0 + 25 * nummer);
		mp.rootPane.getChildren().add(txtSaldo);

		setSaldo(1500);	
	}



	void setVeld(Veld newVeld) 
	{
		if (this.veld != null)
			this.veld.getChildren().remove(this);   //verwijder speler van het oude veld
		if (newVeld != null)		
			newVeld.getChildren().add(this);
		this.veld = newVeld;
	}



	void setSaldo(int saldo)
	{
		txtSaldo.setText(saldo + ",-");
		this.saldo = saldo;
	}



	ArrayList<Straat> getStraten()
	{	
		ArrayList<Straat> straten = new ArrayList<Straat>();
		for (int v = 0; v < mp.velden.length; v++)
			if (mp.velden[v] instanceof Straat)
			{
				Straat straat = (Straat) mp.velden[v];
				if (straat.eigenaar != null && straat.eigenaar.nummer == this.nummer)
					straten.add(straat);
			}
		return straten;
	}



	boolean ownsCity(Stad stad)
	{
		//check of de speler alle straten van de stad bezit
			
		boolean ownsTheCity = true;
		for (Straat straat : stad.straten)
			if (straat.eigenaar == null || straat.eigenaar.nummer != this.nummer)
				ownsTheCity = false;
		return ownsTheCity;
	}



	abstract boolean wantsToBuyStreet(Straat straat);

	abstract boolean accepteertBod(Straat gewensteStraat, Speler bieder, int biedPrijs);
}