import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;



class Straat extends Veld
{
	Stad stad;
	int indInStad;
	Speler eigenaar;
	int prijs;
	int huizenPrijs;
	int aantHuizen;

	Rectangle header;
	Polygon[] huizen;	

	//de tarieven van de andere straten zijn (evenredig) gebaseerd op de tarieven van de Kalverstraat
	static int[] tarievenKalverstraat = new int[] { 50, 200, 600, 1400, 1700 };


	
	Straat(MP mp, int nummer, String naam, Stad stad, int indInStad, int prijs)
	{	
		super(mp, nummer, naam);
		this.stad = stad;
		this.indInStad = indInStad;   //0, 1, of 2
		this.prijs = prijs;	
		huizenPrijs = 50 * (stad.nummer / 2 + 1);
	
		header = new Rectangle(80, 20);
		header.setStroke(Color.BLACK);
		header.setFill(stad.kleur);
		getChildren().add(header);

		Text txtNaam = new Text(naam);
		AnchorPane.setLeftAnchor(txtNaam, 10.0);
		AnchorPane.setTopAnchor(txtNaam, 30.0);
		getChildren().add(txtNaam);
		
		huizen = new Polygon[4];
		for (int h = 0; h < huizen.length; h++)
		{
			huizen[h] = new Polygon();
			huizen[h].getPoints().addAll(new Double[]{
				16.0 + 16 * h,   50.0,
				 8.0 + 16 * h,   58.0,
				 8.0 + 16 * h,   74.0,
				24.0 + 16 * h,   74.0, 			
				24.0 + 16 * h,   58.0});
			huizen[h].setFill(Color.GREEN);
			huizen[h].setStroke(Color.BLACK);
			huizen[h].setVisible(false);
			getChildren().add(huizen[h]);
		}
	}


	
	void setAantHuizen(int aantHuizen)
	{
		this.aantHuizen = aantHuizen;
		for (int i = 0; i < aantHuizen; i++)
			huizen[i].setVisible(true);
		for (int i = aantHuizen; i < huizen.length; i++)
			huizen[i].setVisible(false);
	}	



	void setEigenaar(Speler nweEigenaar)
	{
		if (nweEigenaar == null)
			oppervlak.setFill(Color.LIGHTYELLOW);
		else
			oppervlak.setFill(nweEigenaar.kleur);
		this.eigenaar = nweEigenaar;
	}	


	
	int getTarief() //wat moet een bezoeker betalen als ie op deze straat komt
	{
		int tarief = this.prijs * tarievenKalverstraat[aantHuizen] / 400; 

		//tarief verdubbelt als 1 speler de hele stad bezit (en de straat nog geen huizen heeft) 
		if (aantHuizen == 0  && eigenaar != null && eigenaar.ownsCity(stad))
			tarief *= 2;		
		
		return tarief;
/* oud:
		//int perc = 5 + 2 * aantHuizen;
		int perc = 20 + 20 * aantHuizen;
		return (perc * prijs / 100);	
*/
	}

}