import java.util.*;



public class MP
{
	Stad[] steden;
	Veld[] velden;
	Speler[] spelers;
	Speler spelerADB;



	public static void main(String[] args)
	{	
		new MP(args);
	}



	static void print(String str)
	{
		System.out.print(str);
	}



	static void println(String str)
	{
		System.out.println(str);
	}



	static void println()
	{
		System.out.println();
	}



	static String readln()
	{
		return System.console().readLine();
	}



	void printBord()
	{ 
		String line;

		println();

		//het bord bestaat uit 5 rijen met 8 velden

		for (int veldrij = 0; veldrij < 5; veldrij++)
		{
			line = "";
			for (int k = 0; k < 73; k++)
				line += "#";
			println(line);

			for (int rij = 0; rij < 3; rij++)
			{
				line = "";
				for (int veldkol = 0; veldkol < 8; veldkol++)
				{
					int veldnr = 8 * veldrij + veldkol;
					line += "#" + velden[veldnr].getRegel(rij);
				}
				line += "#";
				println(line);
			}
		}
		line = "";
		for (int k = 0; k < 73; k++)
			line += "#";
		println(line);
		println();
	}



	boolean receiveCommand()
	{
		//print("mp:> ");
		String[] args = readln().split(" ");
		if (args[0].length() == 0)
			return false;
		String cmd = args[0];
		if (cmd.equals("exit"))
			System.exit(0);
		else if (cmd.equals("bord"))
			printBord();	
		else if (cmd.equals("saldos"))
		{	
			for (int i = 0; i < spelers.length; i++)
				print(spelers[i].letter + ": " + spelers[i].saldo + ",-   ");
			//readln();//??
			println();
		}
		else if (cmd.equals("straten"))
			for (int i = 0; i < spelers.length; i++)
			{
				print(spelers[i].letter + ": ");
				spelers[i].printStraten();
			}
		else if (cmd.equals("bied")) //spelerADB biedt op een straat van iemand anders
		{
			if (!(spelerADB instanceof HumanSpeler)) { println("U bent niet aan de beurt."); return true; }
			if (args.length < 3) return true;	//niks geprint bij ongeldige parameters
			String straatNaam = args[1];
			int prijs;
			try { prijs = Integer.parseInt(args[2]); } catch (NumberFormatException nfExc) { return true; } 
			Straat gewensteStraat = getStraat(straatNaam);
			if (gewensteStraat == null)  { println("Onbekende straat."); return true; }
			if (gewensteStraat.eigenaar == null) { println("Deze straat is van niemand."); return true; }
			if (gewensteStraat.eigenaar.nummer == spelerADB.nummer) { println("U bezit deze straat al."); return true; }
			if (gewensteStraat.aantHuizen > 0) { println("U kunt niet bieden op een straat met huizen."); return true; }
			//later toevoegen?? wat als de speler op een complete STAD wil bieden? of op 2 straten tegelijk
			if (prijs < 0) return true;
			if (prijs > spelerADB.saldo) { println("U hebt onvoldoende saldo voor dit bod."); return true; }			
			verwerkBod(gewensteStraat, prijs);

		}
		else if (cmd.equals("koophuis"))
		{
			if (!(spelerADB instanceof HumanSpeler)) { println("U bent niet aan de beurt."); return true; }
			if (args.length < 2) return true;	//niks geprint bij ongeldige parameters
			String stadNaam = args[1];
			//int aantalHuizen = 1; //laat maar. speler koopt maar 1 huis tegelijk
			//if (args.length >= 2)
			//	try { aantalHuizen = Integer.parseInt(args[2]); } catch (NumberFormatException nfExc) { return true; }
			Stad stad = getStad(stadNaam);
			if (stad == null)  { println("Onbekende stad."); return true; }
			if (!(spelerADB.ownsCity(stad))) { println("U bezit niet alle straten van deze stad."); return true; }
			//if (aantalHuizen < 0) return true;
			if (stad.straten[0].huizenPrijs > spelerADB.saldo) { println("Onvoldoende saldo."); return true; }
			if (stad.straten[stad.straten.length - 1].aantHuizen == 4) { println("Deze stad is vol."); return true; }

			verwerkHuizenKoop(stad);
		}

		return true;
	}	
	

	
	void verwerkBod(Straat gewensteStraat, int prijs) 
	{
		//de bieder moet wel aan de beurt zijn   (bieder = spelerADB)

		println(spelerADB.letter + " doet een bod van " + prijs + ",- op " + gewensteStraat.naam + 
			" van speler " + gewensteStraat.eigenaar.letter + ".");

		boolean akkoord = gewensteStraat.eigenaar.accepteertBod(gewensteStraat, prijs);
		if (akkoord)
		{
			println(gewensteStraat.eigenaar.letter + " heeft het bod geaccepteerd. " +
				gewensteStraat.naam + " is nu van " + spelerADB.letter + ".");				
			spelerADB.saldo -= prijs;
			gewensteStraat.eigenaar.saldo += prijs; 
			gewensteStraat.eigenaar = spelerADB;	
		}
		else
		{
			println(gewensteStraat.eigenaar.letter + " heeft het bod afgewezen.");
		}
	}



	void verwerkHuizenKoop(Stad stad)
	{
		//voeg huis toe aan de straat waar nu het minste aantal huizen staan
		Straat straat = stad.straten[0];
		for (int i = 1; i < stad.straten.length; i++)
			if (stad.straten[i].aantHuizen < straat.aantHuizen)
				straat = stad.straten[i];
		
		spelerADB.saldo -= straat.huizenPrijs;
		straat.aantHuizen++;			

		println(spelerADB.letter + " koopt een huis op " + straat.naam + ".");
	}



	Straat getStraat(String straatNaam)
	{
		for (int i = 0; i < steden.length; i++)
			for (Straat straat : steden[i].straten)
				if (straat.naam.equals(straatNaam))
					return straat;
		return null;
	}



	Stad getStad(String stadNaam)
	{
		for (int i = 0; i < steden.length; i++)
			if (steden[i].naam.equals(stadNaam))
				return steden[i];
		return null;
	}



	public MP(String[] args)
	{
		velden = new Veld[40];
		steden = new Stad[] {             //de straten(=velden) worden hier ook gecreeerd
	
			                        //veld-indices         //straat-prijzen
			new Stad(this, 0, "od", new int[]{1, 3},       new int[]{60, 60}),       
			new Stad(this, 1, "ar", new int[]{6, 8 ,9},    new int[]{100, 100, 120}),
			new Stad(this, 2, "ha", new int[]{11, 13, 14}, new int[]{140, 140, 160}), 
			new Stad(this, 3, "ut", new int[]{16, 18, 19}, new int[]{180, 180, 200}),
			new Stad(this, 4 ,"gr", new int[]{21, 23, 24}, new int[]{220, 220, 240}),
			new Stad(this, 5, "dh", new int[]{26, 27, 29}, new int[]{260, 260, 280}),
			new Stad(this, 6, "rd", new int[]{31, 32, 34}, new int[]{300, 300, 320}),
			new Stad(this, 7, "ad", new int[]{37, 39},     new int[]{350, 400}) };

		//creeer de overige velden
		for (int v = 0; v < 40; v++)
			if (velden[v] == null)
				velden[v] = new Veld(this, v, null);



		// lees aantal spelers.   default: 1 human-speler en 3 computer-spelers
		// bvb java MP 2 2

		int aantHumanSpelers = 0, aantCompSpelers = 0; 
		if (args.length == 0)
		{	
			aantHumanSpelers = 1;
			aantCompSpelers = 3;
		}
		if (args.length == 1)
		{
			aantHumanSpelers = Integer.parseInt(args[0]);		
			aantCompSpelers = 0;   //user kan in zn eentje spelen?? (als aantHumanSpelers == 1) 
		}
		if (args.length == 2)
		{
			aantHumanSpelers = Integer.parseInt(args[0]);		
			aantCompSpelers = Integer.parseInt(args[1]);		
		}
		


		//creeer achtereenvolgens de human-spelers en de computer-spelers
	 
		spelers = new Speler[aantHumanSpelers + aantCompSpelers];
		int ind = 0;
		for (int i = 0; i < aantHumanSpelers; i++)
		{
			String strLetter = new String(new char[]{(char)('A' + ind)});
			spelers[ind] = new HumanSpeler(this, ind, strLetter, velden[0]);
			ind++;
		}
		for (int i = 0; i < aantCompSpelers; i++)
		{
			String strLetter = new String(new char[]{(char)('A' + ind)});
			spelers[ind] = new CompSpeler(this, ind, strLetter, velden[0]);
			ind++;
		}	   


		
		for (int sp = 0; sp < spelers.length; sp++)
			spelers[sp].saldo = 1500;
			//klopt toch? zou het startbedrag niet lager moeten zijn naarmate er meer spelers zijn?
			//...want je hebt per persoon minder straten(en huizen) om te kopen			


		printBord();

		boolean einde = false;
		int aanDeBeurtInd = 0;
		int[] dobs = new int[2];

		while (!einde)
		{
			spelerADB = spelers[aanDeBeurtInd];
			println(spelerADB.letter + " is aan de beurt.");
			if (spelerADB instanceof HumanSpeler)
			{
				print("Druk op Enter om te gooien");
				readln();
			}
			dobs[0] = (int)(6 * Math.random() + 1);
			dobs[1] = (int)(6 * Math.random() + 1);
			int somOgen = dobs[0] + dobs[1];
			int newVeldNr = spelerADB.veld.nummer + somOgen;
			if (newVeldNr >= 40)
			{
				newVeldNr -= 40;
				if (newVeldNr == 0)
					spelerADB.saldo += 400;//200;
				else
					spelerADB.saldo += 200;//100;
			}	
			spelerADB.veld = velden[newVeldNr];

			printBord();
	
			println(spelerADB.letter + " gooit: " + dobs[0] + " en " + dobs[1]);
			println(spelerADB.letter + " belandt op " + spelerADB.veld.naam);
		
			if (spelerADB.veld instanceof Straat)
			{
				Straat straat = (Straat) spelerADB.veld; 
				if (straat.eigenaar == null)
				{
					//spelerADB kan de straat kopen
												
					if (spelerADB.saldo >= straat.prijs && spelerADB.wantsToBuyStreet(straat)) 
					{
						spelerADB.saldo -= straat.prijs;
						straat.eigenaar = spelerADB; 
						println(spelerADB.letter + " koopt " + straat.naam);
						/*println(spelerADB.letter + " bezit nu de volgende straten: ");
						spelerADB.printStraten();*/
					}
				}
				else
				{
					if (spelerADB.nummer != straat.eigenaar.nummer)		
					{	
						//spelerADB moet bezoekTarief betalen aan de eigenaar			
						int bezoekTarief = straat.getTarief();	
						spelerADB.saldo -= bezoekTarief;
						straat.eigenaar.saldo += bezoekTarief; //kan eigenlijk niet als spelerADB failliet is
						println(spelerADB.letter + " betaalt " + bezoekTarief + 
							",- bezoek-tarief aan " + straat.eigenaar.letter + ".");
					}
				}
			}		
			
			if (spelerADB instanceof CompSpeler)
			{	
				CompSpeler compSpeler = (CompSpeler) spelerADB; 
				compSpeler.biedOpStraten_buyHouses();
			}

			while (receiveCommand());   //keep receiving commands while cmd is not empty
	
			if (spelerADB.saldo < 0) 
			{
				println("SPELER " + spelerADB.letter + " IS FAILLIET en wordt uit het spel verwijderd.");
				readln();

				//de straten van de failliete speler komen weer in het spel
				for (Straat str : spelerADB.getStraten())
				{
					str.eigenaar = null;
					str.aantHuizen = 0;

					//de computer-spelers moeten (later, bij medespelers) weer kunnen bieden op de failliete straten
					for (Speler speler : spelers)
						if (speler instanceof CompSpeler) 
							((CompSpeler)speler).gebodenOpStraat[str.nummer] = false;
							
				}
			
				//removeSpeler
				Speler[] newSpelers = new Speler[spelers.length - 1];
				for (int i = 0; i < aanDeBeurtInd; i++)
					newSpelers[i] = spelers[i];
				for (int i = aanDeBeurtInd; i < newSpelers.length; i++)
				{
					newSpelers[i] = spelers[i + 1];
					newSpelers[i].nummer = i;
				}
				spelers = newSpelers;
	
				// NB goed opletten wat de NIEUWE index wordt van aanDeBeurt 
				if (aanDeBeurtInd == spelers.length)
					aanDeBeurtInd = 0; 
			}
			else 
			{
			//spelerADB mag nog een keer gooien als ie dubbel heeft gegooid
			//if (dobs[0] == dobs[1])
			//	continue;	
			//(else:) volgende speler aan de beurt
				if (aanDeBeurtInd == spelers.length - 1)
					aanDeBeurtInd = 0; 
				else
					aanDeBeurtInd += 1;
			}
		}

	}

	

}