class Straat extends Veld
{
	Stad stad;
	int indInStad;
	Speler eigenaar;
	int prijs;
	int huizenPrijs;
	int aantHuizen;
		

	//de tarieven van de andere straten zijn (evenredig) gebaseerd op de tarieven van de Kalverstraat
	static int[] tarievenKalverstraat = new int[] { 50, 200, 600, 1400, 1700 };


	
	Straat(MP mp, int nummer, String naam, Stad stad, int indInStad, int prijs)
	{	
		super(mp, nummer, naam);
		this.stad = stad;
		this.indInStad = indInStad;   //0, 1, of 2
		this.prijs = prijs;	
		huizenPrijs = 50 * (stad.nummer / 2 + 1);
	}


	
	String getRegel0()
	{	
		String regel = naam;
		while (regel.length() < 7)				
			regel += " ";
		regel += (eigenaar == null ? " " : eigenaar.letter);
		return regel;
	}



	String getRegel1()
	{	
		String regel = "";
		for (int i = 0; i < aantHuizen; i++)
			regel += "^";
		while (regel.length() < 8)				
			regel += " ";
		return regel;
	}


	
	int getTarief() //wat moet een bezoeker betalen als ie op deze straat komt
	{
		int tarief = this.prijs * tarievenKalverstraat[aantHuizen] / 400; 

		//tarief verdubbelt als 1 speler de hele stad bezit (en de straat nog geen huizen heeft) 
		if (aantHuizen == 0  && eigenaar != null && eigenaar.ownsCity(stad))
			tarief *= 2;		
		
		return tarief;
/* oud:
		//int perc = 5 + 2 * aantHuizen;
		int perc = 20 + 20 * aantHuizen;
		return (perc * prijs / 100);	
*/
	}

}