import java.util.ArrayList;
import javafx.scene.input.KeyCode;



class Slang
{
	Snake snake;
	ArrayList<SlangDeel> delen;
	int direction;
	int gespeeldeRates;
	int ratesRodeAppelZichtbaar;
	int score;

	final static int UP = 0;
	final static int DOWN = 1;
	final static int RIGHT = 2;
	final static int LEFT = 3;

	boolean pauze;
	


	Slang(Snake snake, int lengte)
	{
		this.snake = snake;
		delen = new ArrayList<SlangDeel>();
		for (int i = 0; i < lengte; i++)
		{
			int x_pos = lengte - i - 1;
			int y_pos = snake.aantRij / 2;
			SlangDeel slangDeel = new SlangDeel(this, snake, x_pos, y_pos);
			delen.add(slangDeel);
		}
		
		pauze = false;
		direction = RIGHT;
		gespeeldeRates = 0;
		ratesRodeAppelZichtbaar = -1;
		setScore(0);	
	}

	

	void setScore(int new_score)
	{
		score = new_score;
		snake.txtScore.setText("" + score); 
	}



	void nextStep()
	{
		//check eerst of er een toets is ingedrukt

		KeyCode key = snake.qKeysPressed.poll();  //moet misschien niet altijd tijdens de pauze
		if (key != null)
		{
			switch (key) 
			{	
				case KeyCode.P:
					pauze = !pauze;
					return; 
				//bugje: tijdens de pauze mag de user eigenlijk geen pijltjes-toetsen drukken	
				case KeyCode.UP:
					if (direction != DOWN)
						direction = UP; break;
				case KeyCode.DOWN:
					if (direction != UP)
						direction = DOWN; break;
				case KeyCode.RIGHT:
					if (direction != LEFT)
						direction = RIGHT; break;
				case KeyCode.LEFT:
					if (direction != RIGHT)
						direction = LEFT; break; 
			}
		}


		

		if (pauze)
			return;
//test();
		

		Veld lastVeld = new Veld(delen.getLast().x_pos, delen.getLast().y_pos);
		
		//verplaats de staart van de slang
		for (int i = delen.size() - 1; i > 0; i--)
		{
			delen.get(i).setX_pos(delen.get(i - 1).x_pos);
			delen.get(i).setY_pos(delen.get(i - 1).y_pos);
		}
	
		//verplaats het hoofd van de slang
		SlangDeel voorsteDeel = delen.get(0);
		if (direction == RIGHT) 
		{
			if (voorsteDeel.x_pos == snake.aantKol - 1)  //mag niet tegen de rand aan botsen
				{ snake.eindeSpel(null); return; }
			voorsteDeel.setX_pos(voorsteDeel.x_pos + 1);
		}
		if (direction == LEFT) 
		{
			if (voorsteDeel.x_pos == 0)
				{ snake.eindeSpel(null); return; }
			voorsteDeel.setX_pos(voorsteDeel.x_pos - 1);
		}
		if (direction == UP) 
		{
			if (voorsteDeel.y_pos == 0)
				{ snake.eindeSpel(null); return; }
			voorsteDeel.setY_pos(voorsteDeel.y_pos - 1);
		}
		if (direction == DOWN) 
		{
			if (voorsteDeel.y_pos == snake.aantRij - 1)
				{ snake.eindeSpel(null); return; }
			voorsteDeel.setY_pos(voorsteDeel.y_pos + 1);
		}

		//mag niet tegen zichzelf aan botsen
		for (int i = 1; i < delen.size(); i++)
			if (voorsteDeel.x_pos == delen.get(i).x_pos &&
			    voorsteDeel.y_pos == delen.get(i).y_pos) 
				{ snake.eindeSpel(null); return; }


		//als de slang een groene appel pakt...
		if (voorsteDeel.x_pos == snake.appel.x_pos && 
		    voorsteDeel.y_pos == snake.appel.y_pos)
		{
			setScore(score + 1);

			Veld newAppelLoc = snake.genereerNieuweAppelLocatie(false);
			snake.appel.setX_pos(newAppelLoc.x);
			snake.appel.setY_pos(newAppelLoc.y);	
		
			SlangDeel newDeel = new SlangDeel(this, snake, lastVeld.x, lastVeld.y);
			delen.add(newDeel);

			
		
			if (score % 6 == 0)
			{	//dan wordt er een rode appel zichtbaar
				Veld newRAppelLoc = snake.genereerNieuweAppelLocatie(true);
				snake.rodeAppel.setX_pos(newRAppelLoc.x);
				snake.rodeAppel.setY_pos(newRAppelLoc.y);	
				snake.rodeAppel.body.setVisible(true);
				ratesRodeAppelZichtbaar = gespeeldeRates;
			}	
		} 

		//als de slang een RODE appel pakt...
		if (snake.rodeAppel.body.isVisible() &&
			voorsteDeel.x_pos == snake.rodeAppel.x_pos && 
			voorsteDeel.y_pos == snake.rodeAppel.y_pos)
		{
		
			int voorbijeRates = gespeeldeRates - ratesRodeAppelZichtbaar;
			int voorbijeSeconden =  voorbijeRates * snake.timerInterval / 1000;
			int bonus = 3 * (6 - voorbijeSeconden);
			setScore(score + bonus); 
			snake.rodeAppel.body.setVisible(false);
		}	
			
		//haal de rode appel weg na 6 seconden			
		if (snake.rodeAppel.body.isVisible())
		{
			int voorbijeRates = gespeeldeRates - ratesRodeAppelZichtbaar;
			int voorbijeSeconden =  voorbijeRates * snake.timerInterval / 1000;
			if (voorbijeSeconden >= 6)
				snake.rodeAppel.body.setVisible(false);
		}		

		gespeeldeRates++;	
	}


	
	//verander af en toe van richting (willekeurig)
	void test() 
	{
		int new_direction = (int)(Math.random() * 6);
		if (new_direction >= 4)
			return;
		if (direction == UP && new_direction == DOWN)
			return;
		if (direction == DOWN && new_direction == UP)
			return;
		if (direction == LEFT && new_direction == RIGHT)
			return;
		if (direction == RIGHT && new_direction == LEFT)
			return;
		direction = new_direction;
	}
}