import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.stage.Stage;



public class Snake extends Application 
{
	int aantKol = 13;
	int aantRij = 16;	

	int timerInterval = 120;
	
	Slang slang;
	Appel appel, rodeAppel;
	AnchorPane rootPane;
	Text txtScore;	

	Timer timer;
	
	LinkedList<KeyCode> qKeysPressed;

	Snake snake;

	

	@Override
	public void start(Stage stage) throws Exception 
	{
		snake = this;

		rootPane = new AnchorPane();
	
		Rectangle kader = new Rectangle(aantKol * SlangDeel.width, aantRij * SlangDeel.width);
		kader.setStroke(Color.BLACK);
		kader.setFill(null);
		AnchorPane.setLeftAnchor(kader, 50.0);
		AnchorPane.setTopAnchor(kader, 50.0);
		rootPane.getChildren().add(kader);

		txtScore = new Text();		
		AnchorPane.setLeftAnchor(txtScore, 50.0);
		AnchorPane.setTopAnchor(txtScore, 30.0);
		rootPane.getChildren().add(txtScore);

		appel = new Appel(this, Color.GREEN);
		rodeAppel = new Appel(this, Color.RED);		

		slang = new Slang(this, 3);

		Veld newAppelLoc = genereerNieuweAppelLocatie(false);
		appel.setX_pos(newAppelLoc.x);
		appel.setY_pos(newAppelLoc.y);	
		appel.body.setVisible(true);		
		
		Scene scene = new Scene(rootPane, 700, 500,
			Color.LIGHTGREY);
		stage.setTitle("Snake");
		stage.setScene(scene);
		stage.show();

		qKeysPressed = new LinkedList<KeyCode>();
		scene.setOnKeyPressed(new EventHandler<KeyEvent>() {
            		@Override
            		public void handle(KeyEvent event) 
			{
                		qKeysPressed.add(event.getCode());
                    	}
                });		
		
		timer = new Timer();
		timer.scheduleAtFixedRate(new TimerTask() {
			@Override
			public void run() {
				Platform.runLater(() -> {	
    					nextStep();
	  			});
			}
		}, 1000, timerInterval);
	}

	

	@Override
	public void stop() 
	{
        	timer.cancel();
    	}



	void nextStep()
	{	
		slang.nextStep();
	}
	


	void eindeSpel(String message)
	{
		timer.cancel();
		//...........
	}


	
	Veld genereerNieuweAppelLocatie(boolean rood)
	{
		boolean veldBezet = true;
		int x, y;
		veldBezetCheck:
		while (veldBezet)
		{	
			veldBezet = false;		
			x = (int) (Math.random() * aantKol);
			y = (int) (Math.random() * aantRij);

			//de appel mag niet op dezelfde plek komen als een slang-deel
			for (int i = 0; i < slang.delen.size(); i++)
				if (x == slang.delen.get(i).x_pos && y == slang.delen.get(i).y_pos)
				{
					veldBezet = true;
					continue veldBezetCheck;
				}

			//de appel mag niet op dezelfde plek komen als de andere appel
			if (rood && x == appel.x_pos && y == appel.y_pos)
			{
				veldBezet = true;
				continue veldBezetCheck;
			}
			if (!rood && rodeAppel.body.isVisible() && x == rodeAppel.x_pos && y == rodeAppel.y_pos)
			{
				veldBezet = true;
				continue veldBezetCheck;
			}
			return new Veld(x, y);
		}		
		return null;	
	}



	public static void main(String[] args) 
	{
		launch(args);
	}

}