import java.util.ArrayList;



class Kaart
{	
	final static int PAARD = 0;
	final static int SOLDAAT = 1;
	final static int KANON = 2; 

	final static int[] AANT_PUNT = new int[]{8, 6, 4};
 
	int type;



	Kaart(int type)
	{
		this.type = type;
	}



	String getLetter()
	{
		if (type == PAARD)
			return "P";
		if (type == SOLDAAT)
			return "S";
		if (type == KANON)
			return "K";
		return null;
	}

	
	
	

	static Kaart trekRandomKaart()
	{
		int type = (int) (Math.random() * 3);
		return new Kaart(type);
	}



	static int getAantPunten(ArrayList<Kaart> kaarten)
	{
		if (kaarten.size() != 3) //user moet zelf 3 kaarten selecteren 
			return 0;
				
		//check op 3 dezelfde kaarten
		if (kaarten.get(1).type == kaarten.get(0).type && 
		    kaarten.get(2).type == kaarten.get(0).type)
	 		return AANT_PUNT[kaarten.get(0).type];
		
		if (kaarten.get(1).type != kaarten.get(0).type &&
		    kaarten.get(2).type != kaarten.get(0).type &&
		    kaarten.get(2).type != kaarten.get(1).type)
			return 10;		

		return 0;
	}
 
}