import java.util.ArrayList;
import javafx.scene.layout.AnchorPane;
import javafx.scene.shape.Rectangle;



class Land
{
	final static int MAX_AANT_LEGERS = 25;
	static int count;

	int id;
	Risk risk;
	Continent continent;
	String naam;
	double x, y;
	Speler eigenaar;
	int aantLegers;
	Rectangle[] legers;
	String[] buurLandNamen;
	ArrayList<Land> buurLanden;	



	Land(Risk risk, Continent continent, String naam, double x, double y, String[] buurLandNamen)
	{
		id = count;   //beetje tricky constructie
		count++;

		this.risk = risk;
		this.continent = continent;
		this.naam = naam;
		this.x = x;
		this.y = y;
		this.buurLandNamen = buurLandNamen;

		legers = new Rectangle[MAX_AANT_LEGERS];
		for (int i = 0; i < legers.length; i++)
		{ 
			Rectangle leger = new Rectangle(5, 5);
			AnchorPane.setLeftAnchor(leger, x + 7 * (i % 5));
			AnchorPane.setTopAnchor( leger, y + 7 * (i / 5));
			risk.rootPane.getChildren().add(leger);
			legers[i] = leger;
		}

	}



	void setEigenaar(Speler nweEigenaar)
	{
		eigenaar = nweEigenaar;
		for (int i = 0; i < legers.length; i++)
			legers[i].setFill(nweEigenaar.kleur);
		aantLegers = 0;
	}

	

	void setAantLegers(int aantLegers)
	{
		this.aantLegers = aantLegers;
		for (int i = 0; i < aantLegers; i++)
			legers[i].setVisible(true);
		for (int i = aantLegers; i < legers.length; i++)
			legers[i].setVisible(false);			
	}	



	boolean containsBuurLand(Land land)
	{
		for (Land buurLand : buurLanden)
			if (land.id == buurLand.id)
				return true;
		return false;
	}	

}