import java.io.*;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Alert.AlertType;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputDialog;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Color;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.stage.Stage;



public class Risk extends Application 
{
	final static int MAX_AANT_STARTLEGERS_PER_LAND = 4;
	final static int[] AANT_STARTLEGERS = { 0, 0, 40, 35, 30, 25, 20};
	//static int AANT_STARTLEGERS = 30;

	ArrayList<Continent> continenten;
	ArrayList<Land> landen;
	ArrayList<Speler> spelers;
	int adb_ind;
	Speler adb;
	boolean adbValtAan;
	boolean landVeroverd;
		
	int status;
	final static int LEGERS_PLAATSEN = 0;
	final static int LEGERS_VERPLAATSEN = 1;
	final static int HOOFD_FASE = 2;
	
	
	AnchorPane rootPane;

	Text lblAdb, txtAdb;

	Text lblLegersOver, txtLegersOver;
	Text lblLandToAddLegers;
	ComboBox<String> cboLandToAddLegers;
	Text lblAantLegersToAdd;
	TextField tfAantLegersToAdd;	
	Button btnAddLegers;
	
	AnchorPane movePane;
	Text lblMoveVan, lblMoveNaar;	
	ComboBox<String> cboMoveVan, cboMoveNaar;
	Button btnMoveLegers;

	Button btnNextSpeler;
	Button btnMovingFinished;

	AnchorPane kaartenPane;
	Text[] txtKaarten;
	CheckBox[] chbKaarten;
	Button btnKaartenInleveren;
	Button btnKInleverenOverslaan;

	AnchorPane aanvalPane;	
	Text lblAttackVan, lblAttackNaar;	
	ComboBox<String> cboAttackVan, cboAttackNaar;
	Text txtUitslag;
	Button btnAttack, btnAttackFinished;

	Button btnSave;

	String fileName;



	@Override
	public void start(Stage stage) throws Exception {
		boolean load = false;
		DataInputStream in = null;
		int loaded_adb_ind = -1;
		String strFileName = inputDialog("Typ een bestandsnaam als u een oud spel wilt laden:");
		if (!strFileName.equals(""))
		{
			try
			{
				FileInputStream fis = new FileInputStream(strFileName);
    				in = new DataInputStream(new BufferedInputStream(fis));
				load = true;
    			}
			catch (IOException ioExc)
			{	
				alert("Kan het opgegeven bestand niet vinden");
			}	
					
		
		}

		rootPane = new AnchorPane();
		Image imKaart = new Image("kaart.jpg", 1200.0, 750.0, true, false);
		ImageView ivKaart = new ImageView();
		ivKaart.setImage(imKaart);		
		rootPane.getChildren().add(ivKaart);

		Continent Europa = new Continent(this, "Europa", 5);
		Continent Noord_Amerika = new Continent(this, "Noord-Amerika", 5);
		Continent Zuid_Amerika = new Continent(this, "Zuid-Amerika", 2);
		Continent Afrika = new Continent(this, "Afrika", 3);
		Continent Australie = new Continent(this, "Australie", 2);
		Continent Azie = new Continent(this, "Azie", 7);
	
		continenten = new ArrayList<Continent>();
		continenten.add(Europa);
		continenten.add(Noord_Amerika);
		continenten.add(Zuid_Amerika);
		continenten.add(Afrika);
		continenten.add(Australie);
		continenten.add(Azie);

		landen = new ArrayList<Land>();

		landen.add(new Land(this, Europa, "Iceland", 495.0, 140.0, 
			new String[]{"Greenland", "Scandinavia", "Great Britain"}));
		landen.add(new Land(this, Europa, "Great Britain", 475.0, 245.0, 
			new String[]{"Iceland", "Scandinavia", "Northern Europe", "Western Europe"}));
		landen.add(new Land(this, Europa, "Western Europe", 490.0, 333.0, 
			new String[]{"Great Britain", "Northern Europe", "Southern Europe", "North Africa"}));
		landen.add(new Land(this, Europa, "Southern Europe", 550.0, 365.0, 
			new String[]{"Western Europe", "Northern Europe", "Ukraine", "Middle East", "Egypt", "North Africa"}));
		landen.add(new Land(this, Europa, "Northern Europe", 550.0, 280.0,
			new String[]{"Great Britain", "Scandinavia", "Ukraine", "Southern Europe", "Western Europe"}));
		landen.add(new Land(this, Europa, "Scandinavia", 565.0, 140.0,
			new String[]{"Iceland", "Ukraine", "Northern Europe", "Great Britain"}));
		landen.add(new Land(this, Europa, "Ukraine", 665.0, 190.0,
			new String[]{"Southern Europe", "Northern Europe", "Scandinavia", "Ural", "Afghanistan", "Middle East"}));
		
		landen.add(new Land(this, Noord_Amerika, "Alaska", 60.0, 20.0,
			new String[]{"Kamchatka", "Northwest Territory", "Alberta"}));
		landen.add(new Land(this, Noord_Amerika, "Northwest Territory", 160.0, 20.0,
			new String[]{"Alaska", "Alberta", "Ontario", "Greenland"}));
		landen.add(new Land(this, Noord_Amerika, "Greenland", 490.0, 20.0,
			new String[]{"Northwest Territory", "Ontario", "Quebec", "Iceland"}));
		landen.add(new Land(this, Noord_Amerika, "Alberta", 150.0, 90.0,
			new String[]{"Alaska", "Northwest Territory", "Ontario", "Western United State"}));
		landen.add(new Land(this, Noord_Amerika, "Ontario", 260.0, 110.0,
			new String[]{"Alberta", "Northwest Territory", "Greenland", "Quebec", "Eastern United State", "Western United State"}));
		landen.add(new Land(this, Noord_Amerika, "Quebec", 385.0, 145.0,
			new String[]{"Ontario", "Greenland", "Eastern United State"}));
		landen.add(new Land(this, Noord_Amerika, "Eastern United State", 245.0, 225.0,
			new String[]{"Western United State", "Ontario", "Quebec", "Central America"}));
		landen.add(new Land(this, Noord_Amerika, "Western United State", 120.0, 245.0,
			new String[]{"Alberta", "Ontario", "Eastern United State", "Central America"}));
		landen.add(new Land(this, Noord_Amerika, "Central America", 130.0, 320.0,
			new String[]{"Western United State", "Eastern United State", "Venezuela"}));
		
		landen.add(new Land(this, Zuid_Amerika, "Venezuela", 165.0, 447.0,
			new String[]{"Central America", "Peru", "Brazil"}));
		landen.add(new Land(this, Zuid_Amerika, "Brazil", 265.0, 600.0,
			new String[]{"Venezuela", "Peru", "Argentina", "North Africa"}));
		landen.add(new Land(this, Zuid_Amerika, "Peru", 175.0, 610.0,
			new String[]{"Venezuela", "Brazil", "Argentina"}));
		landen.add(new Land(this, Zuid_Amerika, "Argentina", 150.0, 680.0,
			new String[]{"Peru", "Brazil"}));
				
		landen.add(new Land(this, Afrika, "North Africa", 460.0, 445.0,
			new String[]{"Brazil", "Western Europe", "Southern Europe", "Egypt", "East Africa", "Congo"}));
		landen.add(new Land(this, Afrika, "Egypt", 600.0, 430.0,
			new String[]{"North Africa", "Southern Europe", "Middle East", "East Africa"}));
		landen.add(new Land(this, Afrika, "East Africa", 620.0, 530.0,
			new String[]{"North Africa", "Egypt", "Middle East", "Madagascar", "South Africa", "Congo"}));
		landen.add(new Land(this, Afrika, "Congo", 570.0, 560.0,
			new String[]{"North Africa", "East Africa", "South Africa"}));
		landen.add(new Land(this, Afrika, "South Africa", 570.0, 670.0,
			new String[]{"Congo", "East Africa", "Madagascar"}));
		landen.add(new Land(this, Afrika, "Madagascar", 680.0, 660.0,
			new String[]{"South Africa", "East Africa"}));
		
		landen.add(new Land(this, Australie, "Indonesia", 940.0, 500.0,
			new String[]{"Siam", "New Guinea", "Western Australia"}));
		landen.add(new Land(this, Australie, "New Guinea", 1070.0, 510.0,
			new String[]{"Indonesia", "Western Australia", "Eastern Australia"}));
		landen.add(new Land(this, Australie, "Western Australia", 980.0, 650.0,
			new String[]{"Indonesia", "New Guinea", "Eastern Australia"}));
		landen.add(new Land(this, Australie, "Eastern Australia", 1060.0, 590.0,
			new String[]{"New Guinea", "Western Australia"}));

		landen.add(new Land(this, Azie, "Middle East", 670.0, 425.0,
			new String[]{"East Africa", "Egypt", "Southern Europe", "Ukraine", "Afghanistan", "India"}));
		landen.add(new Land(this, Azie, "Afghanistan", 730.0, 330.0,
			new String[]{"Middle East", "Ukraine", "Ural", "China", "India"}));
		landen.add(new Land(this, Azie, "Ural", 780.0, 180.0,
			new String[]{"Ukraine", "Afghanistan", "China", "Siberia"}));
		landen.add(new Land(this, Azie, "Siberia", 850.0, 150.0,
			new String[]{"Ural", "China", "Mongolia", "Irkutsk", "Yakutsk"}));
		landen.add(new Land(this, Azie, "Irkutsk", 920.0, 140.0,
			new String[]{"Siberia", "Kamchatka", "Mongolia", "Yakutsk"}));
		landen.add(new Land(this, Azie, "Yakutsk", 970.0, 80.0,
			new String[]{"Siberia", "Kamchatka", "Irkutsk"}));
		landen.add(new Land(this, Azie, "Kamchatka", 1065.0, 65.0,
			new String[]{"Mongolia", "Yakutsk", "Irkutsk", "Japan", "Alaska"}));
		landen.add(new Land(this, Azie, "Japan", 1030.0, 300.0,
			new String[]{"Mongolia", "Kamchatka"}));
		landen.add(new Land(this, Azie, "Mongolia", 940.0, 265.0,
			new String[]{"Kamchatka", "Japan", "China", "Siberia", "Irkutsk"}));
		landen.add(new Land(this, Azie, "China", 845.0, 295.0,
			new String[]{"Afghanistan", "Ural", "Siberia", "Mongolia", "Siam", "India"}));
		landen.add(new Land(this, Azie, "Siam", 895.0, 425.0,
			new String[]{"China", "India", "Indonesia"}));
		landen.add(new Land(this, Azie, "India", 785.0, 420.0,
			new String[]{"China", "Middle East", "Afghanistan", "Siam"}));
		
		setBuurLanden();

		

		spelers = new ArrayList<Speler>();

		if (!load)
		{
			int aantSpelers = 0;
			String question = "Met hoeveel spelers willen jullie het spel spelen?";
			while (true)
			{
				String strAantSpelers = inputDialog(question);
				if (strAantSpelers.equals(""))
					continue;
				try { aantSpelers = Integer.parseInt(strAantSpelers); } catch (NumberFormatException nfExc) 						{ continue; } 
				if (aantSpelers < 2 || aantSpelers > Speler.kleuren.length)
					continue;
				break;
			}	
			
			for (int i = 0; i < aantSpelers; i++)
			{
				Speler speler = new Speler(this, i);
				speler.nogTePlaatsenLegers = AANT_STARTLEGERS[aantSpelers];
				spelers.add(speler);
			}
			
//testing
/*
for (Speler speler : spelers)
	for (int i = 0; i < 4; i++)   //geef elke speler 4 kaarten	
		speler.kaarten.add(Kaart.trekRandomKaart());		
*/
			status = LEGERS_PLAATSEN;

			//verdeel de landen willekeurig over de spelers
			ArrayList<Land> overgeblevenLanden = new ArrayList<Land>(landen);
			int spelerInd = 0;
			for (int i = 0; i < landen.size(); i++)
			{
				int landInd = (int)(Math.random() * overgeblevenLanden.size());
				overgeblevenLanden.get(landInd).setEigenaar(spelers.get(spelerInd));
				overgeblevenLanden.get(landInd).setAantLegers(1);
				spelers.get(spelerInd).nogTePlaatsenLegers--;
				overgeblevenLanden.remove(landInd);
				spelerInd = (spelerInd + 1) % spelers.size();	 
			}



		}
		else //load
		{	
			try 
			{
				int aantSpelers = in.readInt();
				for (int i = 0; i < aantSpelers; i++)
				{
					Speler speler = new Speler(this, i);
					spelers.add(speler);
					speler.uitgeschakeld = in.readBoolean();
					int aantKaarten = in.readInt();
					for (int j = 0; j < aantKaarten; j++)
						speler.kaarten.add(new Kaart(in.readInt())); //reads kaart-type		
				}
				for (Land land : landen)
				{
					land.setEigenaar(spelers.get(in.readInt()));
					land.setAantLegers(in.readInt());       //???????? hier al set gebruiken??

				}
				
				loaded_adb_ind = in.readInt();
				in.close();
			}
			catch (IOException ioExc)
			{
				alert("Fout bij het laden van het bestand");
				System.exit(0);
			}
			this.fileName = strFileName;
			status = HOOFD_FASE;
		}	


		Scene scene = new Scene(rootPane, 1500, 750,
			Color.LIGHTGREY);
		stage.setTitle("Risk");
		stage.setScene(scene);
		stage.show();

		

		lblAdb = new Text("Aan de beurt:");
		AnchorPane.setLeftAnchor(lblAdb, 1160.0);
		AnchorPane.setTopAnchor(lblAdb, 10.0); 
		rootPane.getChildren().add(lblAdb);
		
		txtAdb = new Text("");
		AnchorPane.setLeftAnchor(txtAdb, 1260.0);
		AnchorPane.setTopAnchor(txtAdb, 10.0); 
		rootPane.getChildren().add(txtAdb);

		
		lblLegersOver = new Text("Legers:");
		AnchorPane.setLeftAnchor(lblLegersOver, 1160.0);
		AnchorPane.setTopAnchor(lblLegersOver, 50.0); 
		rootPane.getChildren().add(lblLegersOver);
	
		txtLegersOver = new Text("0");
		AnchorPane.setLeftAnchor(txtLegersOver, 1160.0);
		AnchorPane.setTopAnchor(txtLegersOver, 70.0); 
		rootPane.getChildren().add(txtLegersOver);
	
		lblLandToAddLegers = new Text("Land:");
		AnchorPane.setLeftAnchor(lblLandToAddLegers, 1210.0);
		AnchorPane.setTopAnchor(lblLandToAddLegers, 50.0); 
		rootPane.getChildren().add(lblLandToAddLegers);
		
		cboLandToAddLegers = new ComboBox<String>();		
		AnchorPane.setLeftAnchor(cboLandToAddLegers, 1210.0);
		AnchorPane.setTopAnchor(cboLandToAddLegers, 70.0); 
		rootPane.getChildren().add(cboLandToAddLegers);
		
		lblAantLegersToAdd = new Text("Aant.:");
		AnchorPane.setLeftAnchor(lblAantLegersToAdd, 1380.0);
		AnchorPane.setTopAnchor(lblAantLegersToAdd, 50.0); 
		rootPane.getChildren().add(lblAantLegersToAdd);
				
		tfAantLegersToAdd = new TextField();
		tfAantLegersToAdd.setMaxWidth(30);
		AnchorPane.setLeftAnchor(tfAantLegersToAdd, 1380.0);
		AnchorPane.setTopAnchor(tfAantLegersToAdd, 70.0);
		rootPane.getChildren().add(tfAantLegersToAdd);
			
		btnAddLegers = new Button("Plaats");
		AnchorPane.setLeftAnchor(btnAddLegers, 1420.0);
		AnchorPane.setTopAnchor(btnAddLegers, 70.0);
		rootPane.getChildren().add(btnAddLegers);

		btnAddLegers.setOnAction(new EventHandler<ActionEvent>() {
			@Override public void handle(ActionEvent e) 
			{
				plaatsLegers();
			}
		});		
	

	
		movePane = new AnchorPane();
		AnchorPane.setLeftAnchor(movePane, 1160.0);
		AnchorPane.setTopAnchor(movePane, 120.0);
		rootPane.getChildren().add(movePane);
		movePane.setVisible(false);

		lblMoveVan = new Text("Van:");
		AnchorPane.setLeftAnchor(lblMoveVan, 0.0);
		AnchorPane.setTopAnchor(lblMoveVan, 3.0); 
		movePane.getChildren().add(lblMoveVan);

		lblMoveNaar = new Text("Naar:");
		AnchorPane.setLeftAnchor(lblMoveNaar, 0.0);
		AnchorPane.setTopAnchor(lblMoveNaar, 33.0); 
		movePane.getChildren().add(lblMoveNaar);
		
		cboMoveVan = new ComboBox<String>();		
		AnchorPane.setLeftAnchor(cboMoveVan, 40.0);
		AnchorPane.setTopAnchor(cboMoveVan, 0.0); 
		movePane.getChildren().add(cboMoveVan);
		
		cboMoveNaar = new ComboBox<String>();		
		AnchorPane.setLeftAnchor(cboMoveNaar, 40.0);
		AnchorPane.setTopAnchor(cboMoveNaar, 30.0); 
		movePane.getChildren().add(cboMoveNaar);

		btnMoveLegers = new Button("Verplaats");
		AnchorPane.setLeftAnchor(btnMoveLegers, 210.0);
		AnchorPane.setTopAnchor(btnMoveLegers, 15.0);
		movePane.getChildren().add(btnMoveLegers);
		
		btnNextSpeler = new Button("Volgende Speler");
		AnchorPane.setLeftAnchor(btnNextSpeler, 1160.0);
		AnchorPane.setTopAnchor(btnNextSpeler, 710.0);
		rootPane.getChildren().add(btnNextSpeler);
		btnNextSpeler.setVisible(false);

		btnMovingFinished = new Button("Iedereen is klaar met verplaatsen");
		AnchorPane.setLeftAnchor(btnMovingFinished, 1280.0);
		AnchorPane.setTopAnchor(btnMovingFinished, 710.0);
		rootPane.getChildren().add(btnMovingFinished);
		btnMovingFinished.setVisible(false);

		btnNextSpeler.setOnAction(new EventHandler<ActionEvent>() {
			@Override public void handle(ActionEvent e) 
			{
				setAdb((adb_ind + 1) % spelers.size());
			}
		});
		
		btnMoveLegers.setOnAction(new EventHandler<ActionEvent>() {
			@Override public void handle(ActionEvent e) 
			{
				verplaatsLeger();
			}
		});
	
		btnMovingFinished.setOnAction(new EventHandler<ActionEvent>() {
			@Override public void handle(ActionEvent e) 
			{
				startHoofdFase();
			}
		});

		cboMoveVan.valueProperty().addListener(new ChangeListener<String>() {
         		@Override
         		public void changed(ObservableValue<? extends String> changed, String oldVal, String newVal) 
			{
				newMoveVanLandSelected(newVal);
//System.out.println("MoveVan changed");
			}
		});



		kaartenPane = new AnchorPane();	
		AnchorPane.setLeftAnchor(kaartenPane, 1160.0);
		AnchorPane.setTopAnchor(kaartenPane, 210.0);
		rootPane.getChildren().add(kaartenPane);
		kaartenPane.setVisible(false);

		txtKaarten = new Text[5];
		chbKaarten = new CheckBox[5];	

		for (int i = 0; i < 5; i++)
		{	
			txtKaarten[i] = new Text("P");
			AnchorPane.setLeftAnchor(txtKaarten[i], 20.0 * i);
			AnchorPane.setTopAnchor(txtKaarten[i], 0.0);
			kaartenPane.getChildren().add(txtKaarten[i]);	
					
			chbKaarten[i] = new CheckBox();
			AnchorPane.setLeftAnchor(chbKaarten[i], 20.0 * i);
			AnchorPane.setTopAnchor(chbKaarten[i], 15.0);
			kaartenPane.getChildren().add(chbKaarten[i]);
		}		
		
		btnKaartenInleveren = new Button("Kaarten inleveren");
		AnchorPane.setLeftAnchor(btnKaartenInleveren, 120.0);
		AnchorPane.setTopAnchor(btnKaartenInleveren, 5.0);
		kaartenPane.getChildren().add(btnKaartenInleveren);
		
		btnKInleverenOverslaan = new Button("Overslaan");
		AnchorPane.setLeftAnchor(btnKInleverenOverslaan, 240.0);
		AnchorPane.setTopAnchor(btnKInleverenOverslaan, 5.0);
		kaartenPane.getChildren().add(btnKInleverenOverslaan);
		
		btnKaartenInleveren.setOnAction(new EventHandler<ActionEvent>() {
			@Override public void handle(ActionEvent e) 
			{
				kaartenInleveren();
			}
		});		

		btnKInleverenOverslaan.setOnAction(new EventHandler<ActionEvent>() {
			@Override public void handle(ActionEvent e) 
			{
				startLegersPlaatsenSubfase();
			}
		});		

		

		aanvalPane = new AnchorPane();	
		AnchorPane.setLeftAnchor(aanvalPane, 1160.0);
		AnchorPane.setTopAnchor(aanvalPane, 300.0);
		rootPane.getChildren().add(aanvalPane);
		aanvalPane.setVisible(false);

		lblAttackVan = new Text("Vanuit:");
		AnchorPane.setLeftAnchor(lblAttackVan, 0.0);
		AnchorPane.setTopAnchor(lblAttackVan, 3.0); 
		aanvalPane.getChildren().add(lblAttackVan);

		lblAttackNaar = new Text("Doelwit:");
		AnchorPane.setLeftAnchor(lblAttackNaar, 0.0);
		AnchorPane.setTopAnchor(lblAttackNaar, 33.0); 
		aanvalPane.getChildren().add(lblAttackNaar);
		
		cboAttackVan = new ComboBox<String>();		
		AnchorPane.setLeftAnchor(cboAttackVan, 60.0);
		AnchorPane.setTopAnchor(cboAttackVan, 0.0); 
		aanvalPane.getChildren().add(cboAttackVan);
		
		cboAttackNaar = new ComboBox<String>();		
		AnchorPane.setLeftAnchor(cboAttackNaar, 60.0);
		AnchorPane.setTopAnchor(cboAttackNaar, 30.0); 
		aanvalPane.getChildren().add(cboAttackNaar);

		txtUitslag = new Text("Laatste slag:");	
		AnchorPane.setLeftAnchor(txtUitslag, 0.0);
		AnchorPane.setTopAnchor(txtUitslag, 70.0); 
		aanvalPane.getChildren().add(txtUitslag);

		btnAttack = new Button("Aanvallen");
		AnchorPane.setLeftAnchor(btnAttack, 230.0);
		AnchorPane.setTopAnchor(btnAttack, 15.0);
		aanvalPane.getChildren().add(btnAttack);
		
		btnAttackFinished = new Button("Klaar");
		AnchorPane.setLeftAnchor(btnAttackFinished, 230.0);
		AnchorPane.setTopAnchor(btnAttackFinished, 70.0);
		aanvalPane.getChildren().add(btnAttackFinished);

		btnAttack.setOnAction(new EventHandler<ActionEvent>() {
			@Override public void handle(ActionEvent e) 
			{
				aanvallen();
			}
		});

		btnAttackFinished.setOnAction(new EventHandler<ActionEvent>() {
			@Override public void handle(ActionEvent e) 
			{
				klaarMetAanvallen();
			}
		});

		cboAttackVan.valueProperty().addListener(new ChangeListener<String>() {
         		@Override
         		public void changed(ObservableValue<? extends String> changed, String oldVal, String newVal) 
			{
				newAttackVanLandSelected(newVal);
//System.out.println("AttackVan changed");
			}
		});

		

		btnSave = new Button("Opslaan");
		AnchorPane.setLeftAnchor(btnSave, 1280.0);
		AnchorPane.setTopAnchor(btnSave, 710.0);
		rootPane.getChildren().add(btnSave);
		btnSave.setVisible(false);

		btnSave.setOnAction(new EventHandler<ActionEvent>() {
			@Override public void handle(ActionEvent e) 
			{
				save();
			}
		});

		
		if (!load)
			setAdb(0);
		else
		{
			movePane.setVisible(true);
			btnNextSpeler.setVisible(true);
			setAdb(loaded_adb_ind);	
		}	
	
		//testing	
		//landen.getLast().setAantLegers(25);
		
	}

	

	void setAdb(int adb_ind)
	{

		this.adb_ind = adb_ind;
		adb = spelers.get(adb_ind);

		if (adb.uitgeschakeld)
		{
			setAdb((adb_ind + 1) % spelers.size());
			return;
		}

		txtAdb.setText(adb.kleurNaam);
   		txtAdb.setFill(adb.kleur);

		if (status == LEGERS_PLAATSEN)
		{
			txtLegersOver.setText("" + adb.nogTePlaatsenLegers);
			vulLandenCombo(cboLandToAddLegers);
			return;
		}

		if (status == LEGERS_VERPLAATSEN)
		{
			vulLandenCombo(cboMoveVan);
			//vulLandenCombo(cboMoveNaar);
			return;
		}

		//else: (status == HOOFD_FASE) 

		btnAddLegers.setDisable(true);
		btnMoveLegers.setDisable(true);
		btnNextSpeler.setDisable(true);
		btnSave.setVisible(false);

		int continentenBonus = 0;
		for (Continent continent : continenten)
			if (continent.isOwnedBy(adb))
				continentenBonus += continent.aantLegersWaard;		
		setNogTePlaatsenLegers(continentenBonus);		

		vulLandenCombo(cboLandToAddLegers);
		vulLandenCombo(cboMoveVan);
		//vulLandenCombo(cboMoveNaar);
			

		drawKaartenPane();		

		btnKaartenInleveren.setDisable(false);
		btnKInleverenOverslaan.setDisable(adb.kaarten.size() == 5); //dan moet speler een kaart inleveren (mag niet overslaan)
	
		kaartenPane.setVisible(true);

	}


	
	void drawKaartenPane()
	{
		for (int i = 0; i < adb.kaarten.size(); i++)
		{
			txtKaarten[i].setText(adb.kaarten.get(i).getLetter());
			chbKaarten[i].setSelected(false);
			txtKaarten[i].setVisible(true);
			chbKaarten[i].setVisible(true);
		}		
		for (int i = adb.kaarten.size(); i < 5; i++)
		{
			txtKaarten[i].setVisible(false);
			chbKaarten[i].setVisible(false);
		}
	}



	void vulLandenCombo(ComboBox<String> cbo)
	{
		cbo.getItems().clear();
		for (Land land : landen)
			if (land.eigenaar.id == adb.id)
				cbo.getItems().add(land.naam);
		cbo.setValue(cbo.getItems().get(0));
		
	}


	
	void newMoveVanLandSelected(String landNaam)
	{
		//System.out.println("landNaam = " + landNaam);
		if (landNaam == null)
			return;

		if (status == LEGERS_VERPLAATSEN)
			vulLandenCombo(cboMoveNaar);
		else
		{

			cboMoveNaar.getItems().clear();
			Land moveVan = getLand(landNaam);
			for (Land buurLand : moveVan.buurLanden)
				if (buurLand.eigenaar.id == adb.id)
					cboMoveNaar.getItems().add(buurLand.naam);
			if (cboMoveNaar.getItems().size() > 0)
				cboMoveNaar.setValue(cboMoveNaar.getItems().get(0));
		}
		
	}

	
	
	void newAttackVanLandSelected(String landNaam)
	{
//System.out.println("landNaam = " + landNaam);
		if (landNaam == null)
			return;
		
		cboAttackNaar.getItems().clear();
		Land attackVan = getLand(landNaam);
		for (Land buurLand : attackVan.buurLanden)
			if (buurLand.eigenaar.id != adb.id)
				cboAttackNaar.getItems().add(buurLand.naam);
		if (cboAttackNaar.getItems().size() > 0)
			cboAttackNaar.setValue(cboAttackNaar.getItems().get(0));	
	}



	void setNogTePlaatsenLegers(int aant)
	{
		adb.nogTePlaatsenLegers = aant;
		txtLegersOver.setText("" + adb.nogTePlaatsenLegers);
	}



	void plaatsLegers()
	{
		String landNaam = cboLandToAddLegers.getValue();
		//System.out.println(landNaam);
		Land land = getLand(landNaam);

		int aantLegersToAdd = 0;
		try { aantLegersToAdd = Integer.parseInt(tfAantLegersToAdd.getText()); } catch (NumberFormatException nfExc) { return; } 
 		if (aantLegersToAdd <= 0 || aantLegersToAdd > adb.nogTePlaatsenLegers)
			return;
		if (status == LEGERS_PLAATSEN && land.aantLegers + aantLegersToAdd > MAX_AANT_STARTLEGERS_PER_LAND) 
			return;
		if (status == HOOFD_FASE && land.aantLegers + aantLegersToAdd > Land.MAX_AANT_LEGERS)
			return; 
		
		land.setAantLegers(land.aantLegers + aantLegersToAdd);
		
		setNogTePlaatsenLegers(adb.nogTePlaatsenLegers - aantLegersToAdd);

		if (status == LEGERS_PLAATSEN)
		{
			if (adb.nogTePlaatsenLegers == 0)
			{ 
				if (adb_ind == spelers.size() - 1) //laatste speler is klaar met legers plaatsen
					startVerplaatsenLegers();
				else
					setAdb(adb_ind + 1);
			}	
		}	
		if (status == HOOFD_FASE)
			if (adb.nogTePlaatsenLegers == 0)
				klaarMetLegersPlaatsenInHoofdFase();
	}


//	ComboBox cboMoveVan, cboMoveNaar;

	void verplaatsLeger()
	{
		Land landVan = getLand(cboMoveVan.getValue());
		Land landNaar = getLand(cboMoveNaar.getValue());
		if (landNaar == null)
			return;
		if (landVan.id == landNaar.id)
			return;		
		if (landVan.aantLegers == 1) // er moet altijd 1 leger blijven staan in een land
			return;	
		if (status == LEGERS_VERPLAATSEN && landNaar.aantLegers == MAX_AANT_STARTLEGERS_PER_LAND)	
			return;
		if (landNaar.aantLegers == Land.MAX_AANT_LEGERS)
			return;
		
		if (status == HOOFD_FASE && !landVan.containsBuurLand(landNaar))
			return;

		landVan.setAantLegers(landVan.aantLegers - 1);	
		landNaar.setAantLegers(landNaar.aantLegers + 1);

		if (status == HOOFD_FASE)
		{
			setNogTePlaatsenLegers(adb.nogTePlaatsenLegers - 1);
			if (adb.nogTePlaatsenLegers == 0)
				btnMoveLegers.setDisable(true);
		}	
	}
	


	void startVerplaatsenLegers()
	{
		status = LEGERS_VERPLAATSEN;
		btnAddLegers.setDisable(true);		
		
		movePane.setVisible(true);
		btnNextSpeler.setVisible(true);
		btnMovingFinished.setVisible(true);		

		setAdb(0);
	}



	void startHoofdFase()
	{	
		status = HOOFD_FASE;
		btnMovingFinished.setVisible(false);   //eigenlijk removen. werkt dat met rootpane..remove()?
		
		setAdb(0);
	}


	
	void kaartenInleveren()
	{
		ArrayList<Kaart> selKaarten = new ArrayList<Kaart>();
		for (int i = 0; i < adb.kaarten.size(); i++)
			if (chbKaarten[i].isSelected())
				selKaarten.add(adb.kaarten.get(i));	
		
		int aantPunten = Kaart.getAantPunten(selKaarten);
		
		if (aantPunten == 0)
			return;

		setNogTePlaatsenLegers(adb.nogTePlaatsenLegers + aantPunten);

		//verwijder de ingeleverde kaarten: maak een nieuwe kaarten-lijst voor adb
		ArrayList<Kaart> newKaarten = new ArrayList<Kaart>();		
		for (int i = 0; i < adb.kaarten.size(); i++)
			if (!chbKaarten[i].isSelected())
				newKaarten.add(adb.kaarten.get(i));	
		adb.kaarten = newKaarten;
		drawKaartenPane();

		startLegersPlaatsenSubfase();
	}


	
		
	void startLegersPlaatsenSubfase()
	{
		btnKaartenInleveren.setDisable(true);
		btnKInleverenOverslaan.setDisable(true);

		String message = adb.kleurNaam + ", wil je deze beurt gaan aanvallen?";
		Alert alert = new Alert(AlertType.CONFIRMATION, message);
		Optional<ButtonType> result = alert.showAndWait();
 		adbValtAan = (result.isPresent() && result.get() == ButtonType.OK);		

		if (!adbValtAan) 
		{
			int aantLegersErbij = adb.aantLanden() / 3;
			if (aantLegersErbij < 3)
				aantLegersErbij = 3;
			setNogTePlaatsenLegers(adb.nogTePlaatsenLegers + aantLegersErbij);
		}
	
		if (adb.nogTePlaatsenLegers > 0) 
		{
			btnAddLegers.setDisable(false);
			alert(adb.kleurNaam + ", je kunt nu legers plaatsen.");
		}
		else	
			klaarMetLegersPlaatsenInHoofdFase();
	}



	void klaarMetLegersPlaatsenInHoofdFase()
	{
		btnAddLegers.setDisable(true);
		if (adbValtAan)
		{
			landVeroverd = false;
			vulLandenCombo(cboAttackVan);
			aanvalPane.setVisible(true);
		}
		else		
			startLegersVerplaatsenSubfase();
				
	}	



	void aanvallen()
	{
		String strLandVan = cboAttackVan.getValue();
		String strLandNaar = cboAttackNaar.getValue();
		if (strLandVan == null || strLandNaar == null)
			return;
		Land landVan = getLand(strLandVan);
		Land landNaar = getLand(strLandNaar);
		if (landVan.id == landNaar.id)
			return;		
		if (landVan.aantLegers == 1) // er moet altijd 1 leger blijven staan in een land
			return;	
		if (landNaar.eigenaar.id == landVan.eigenaar.id)
			return;
		if (!landVan.containsBuurLand(landNaar))
			return;		
				
		//bepaal met hoeveel legers er aangevallen gaat worden
		int aantAanvLegers = 3; 
		if (landVan.aantLegers == 2)
			aantAanvLegers = 1;
		if (landVan.aantLegers == 3)
			aantAanvLegers = 2;
		//bepaal met hoeveel legers er verdedigd gaat worden		
		int aantVerdLegers = 2;
		if (landNaar.aantLegers == 1)
			aantVerdLegers = 1;

		StrijdResult strijdResult = strijd(aantAanvLegers, aantVerdLegers);
		landVan.setAantLegers(landVan.aantLegers - strijdResult.verdWinst);
		landNaar.setAantLegers(landNaar.aantLegers - strijdResult.aanvWinst);
		txtUitslag.setText("Laatste Slag:   " + strijdResult.aanvWinst + " - " + strijdResult.verdWinst);
		
		if (landNaar.aantLegers == 0)
		{
			landVeroverd = true;
						
			if (landNaar.eigenaar.aantLanden() == 1)   //dit was het laatste land van die speler
			{	
				landNaar.eigenaar.uitgeschakeld = true;
				alert(landNaar.eigenaar.kleurNaam + " is uitgeschakeld.");	
			}
			int aantLegersMee = 0; 
			int maxAantLegersMee = landVan.aantLegers - 1;
			String question = landNaar.naam + " is veroverd. Met hoeveel legers wil je het veroverde land betreden (max. " + 				maxAantLegersMee + ") ?";
			while (true)
			{
				String strAantLegersMee = inputDialog(question);
				if (strAantLegersMee.equals(""))
					continue;
				try { aantLegersMee = Integer.parseInt(strAantLegersMee); } catch (NumberFormatException nfExc) 						{ continue; } 
				if (aantLegersMee < 1 || aantLegersMee > maxAantLegersMee)
					continue;
				break;
			}	
			
			landNaar.setEigenaar(adb);
			landNaar.setAantLegers(aantLegersMee);
			landVan.setAantLegers(landVan.aantLegers - aantLegersMee); 	
		
			vulLandenCombo(cboAttackVan);
							
		} 
	}



	void klaarMetAanvallen()
	{
		aanvalPane.setVisible(false);

		if (landVeroverd)
		{
			Kaart nweKaart = Kaart.trekRandomKaart();
			adb.kaarten.add(nweKaart);
			drawKaartenPane();			
			alert("Je hebt een nieuwe kaart verdiend: " + nweKaart.getLetter() +".");
		}

		startLegersVerplaatsenSubfase();
	}


	
	void startLegersVerplaatsenSubfase()
	{	
		setNogTePlaatsenLegers(7);
		vulLandenCombo(cboLandToAddLegers);  //eigenlijk niet nodig
		vulLandenCombo(cboMoveVan);
		//vulLandenCombo(cboMoveNaar);
		btnMoveLegers.setDisable(false);
		btnNextSpeler.setDisable(false);
		btnSave.setVisible(true);
		alert(adb.kleurNaam + ", je kunt nu legers verplaatsen.");
	}
 


	void setBuurLanden()
	{
		for (Land land : landen)
		{
			land.buurLanden = new ArrayList<Land>();
			for (int i = 0; i < land.buurLandNamen.length; i++)
			{
				Land buurland = getLand(land.buurLandNamen[i]);
				if (buurland == null)
					System.out.println("Onbekend buurland: " + land.buurLandNamen[i]);
				else
					land.buurLanden.add(buurland);
			}	
		}
	}



	StrijdResult strijd(int aantAanvLegers, int aantVerdLegers)
	{
		if (aantVerdLegers == 1)
		{
			boolean verdWint = true;
			int dobVerd = dob();
			for (int d = 0; d < aantAanvLegers; d++)
				if (dob() > dobVerd)
					verdWint = false;
			return (verdWint ? new StrijdResult(0, 1) : new StrijdResult(1, 0)); 
		}
		
		//else: aantVerdLegers = 2		

		if (aantAanvLegers == 1)   //1 tegen 2
		{
			int dobAanv = dob();
			if (dobAanv > dob() && dobAanv > dob())
				return new StrijdResult(1, 0);
			else
				return new StrijdResult(0, 1); 
		}
		
		StrijdResult strijdResult = new StrijdResult(0, 0);
		int[] dobsAanv;
		int[] dobsVerd = new int[]{dob(), dob()};	
		if (aantAanvLegers == 3)
		{
			int[] threeDobsAanv = new int[]{dob(), dob(), dob()};
//System.out.println(Arrays.toString(threeDobsAanv));
//System.out.println(Arrays.toString(dobsVerd));
			Arrays.sort(threeDobsAanv); //sorts ASCending
			dobsAanv = new int[]{threeDobsAanv[1], threeDobsAanv[2]};  //elimineer het laagste element([0])...
			//... en behandel het geval vervolgens als 2-tegen-2
		}
		else //aantAanvLegers = 2)
		{
			dobsAanv = new int[]{dob(), dob()};
		}

		Arrays.sort(dobsAanv);
		Arrays.sort(dobsVerd);
		for (int i = 0; i < 2; i++)  //hij begint met de laagste 2 te vergelijken, maar dat maakt niet uit
			if (dobsAanv[i] > dobsVerd[i])
				strijdResult.aanvWinst++;
			else
				strijdResult.verdWinst++;				
					
		return strijdResult;
	}



	int dob()
	{
		return (int) (Math.random() * 6 + 1);
	}	



	Land getLand(String landNaam)
	{
		for (Land land : landen)
			if (land.naam.equals(landNaam))
				return land;
		return null;
	}



	void alert(String message)
	{
		(new Alert(AlertType.INFORMATION, message)).showAndWait();
	}



	String inputDialog(String message) 	
	{
		TextInputDialog dialog = new TextInputDialog("");
		dialog.setContentText(message);
 		dialog.showAndWait();
		return dialog.getEditor().getText(); 
	}


	
	void save()
	{
		String strFileName = null;
		if (this.fileName == null)
			strFileName = inputDialog("Bestandsnaam:");
		else
			strFileName = this.fileName;
		
		try
		{
			if (new File(strFileName).isFile()) //check if file already exists
			{
				alert("Er bestaat al een bestand met die naam.");
				return;
			}	
			FileOutputStream fos = new FileOutputStream(strFileName);
			DataOutputStream out = new DataOutputStream(new BufferedOutputStream(fos));
    
			out.writeInt(spelers.size());
			for (Speler speler : spelers)
			{
				out.writeBoolean(speler.uitgeschakeld);
				out.writeInt(speler.kaarten.size());
				for (Kaart kaart : speler.kaarten)
					out.writeInt(kaart.type);
				
			}
			for (Land land : landen)
			{
				out.writeInt(land.eigenaar.id);
				out.writeInt(land.aantLegers);
			}
			int new_adb_ind = (adb_ind + 1) % spelers.size();  
			out.writeInt(new_adb_ind);
			out.close();
	
		}
		catch (IOException ioExc)
		{
			alert("Fout bij het opslaan.");
			return;
		}
		this.fileName = strFileName;		
		alert("Opslaan geslaagd.");
		
	}



	public static void main(String[] args) 
	{
		launch(args);
	}

}