import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.text.Text;
import javafx.stage.Stage;



public class Schaak extends Application 
{
	Spel spel;
	boolean draaiBordOm;
	Image[] imLeegVeld;
	Image[][][] imStukken;    //[type] [kleur] [veldkleur]
	ImageView[][] ivVelden;
	
	Text[] rijLabel, kolLabel;
	TextField tfZet;
	


	public void start(Stage stage) throws Exception
	{
		AnchorPane rootPane = new AnchorPane();

		ivVelden = new ImageView[8][8];

		imLeegVeld = new Image[2];
		imLeegVeld[Stuk.WIT] = new Image("schaakstukken/leeg_wit_veld.bmp"); 
		imLeegVeld[Stuk.ZWART] = new Image("schaakstukken/leeg_zwart_veld.bmp"); 
		for (int r = 0; r < 8; r++)
			for (int k = 0; k < 8; k++)
			{
				ivVelden[r][k] = new ImageView();
				if ( (r + k) % 2 == 0)
					ivVelden[r][k].setImage(imLeegVeld[Stuk.ZWART]);
				else
					ivVelden[r][k].setImage(imLeegVeld[Stuk.WIT]);
				ivVelden[r][k].setX(50 + 59 * k);
				ivVelden[r][k].setY(463 - 59 * r);
				rootPane.getChildren().add(ivVelden[r][k]);
			}

		imStukken = new Image[6][2][2];
		for (int type = 0; type < 6; type++)
			for (int kleur = 0; kleur < 2; kleur++)
				for (int veldKleur = 0; veldKleur < 2; veldKleur++)
				{
					String filename = "schaakstukken/" + 
						Stuk.typeNamen[type] + "_" +
						(kleur == Stuk.WIT ? "wit" : "zwart") + "_op_" + 
						(veldKleur == Stuk.WIT ? "wit" : "zwart") + ".bmp"; 
					//System.out.println(filename);
					imStukken[type][kleur][veldKleur] = new Image(filename);
				}		
		

		rijLabel = new Text[8];
		kolLabel = new Text[8];
		for (int r = 0; r < 8; r++)
		{
			rijLabel[r] = new Text();
			AnchorPane.setLeftAnchor(rijLabel[r], 25.0);
			AnchorPane.setTopAnchor(rijLabel[r], 484.0 - 59 * r); 
			rootPane.getChildren().add(rijLabel[r]);
		}
		for (int k = 0; k < 8; k++)
		{
			kolLabel[k] = new Text();
			AnchorPane.setLeftAnchor(kolLabel[k], 75.0 + 59 * k);
			AnchorPane.setTopAnchor(kolLabel[k], 539.0); 
			rootPane.getChildren().add(kolLabel[k]);
		}
	
		Scene scene = new Scene(rootPane, 750, 750);
		stage.setTitle("Schaak");
		stage.setScene(scene);
		stage.show();
		
		Spel.init();
		spel = new Spel();
		
		int user_kleur = (Math.random() < 0.5 ? Stuk.WIT : Stuk.ZWART);
		draaiBordOm = (user_kleur == Stuk.ZWART);
		if (user_kleur == Stuk.ZWART)
			spel.doeEenComputerZet();	
		//spel.printStukken();
		//spel.zet(3, 1, 3, 6);
		//spel.zet("d2d4");
		//spel.printStukken();
		drawBord(draaiBordOm);

		tfZet = new TextField();
		tfZet.setMaxWidth(50);
		AnchorPane.setLeftAnchor(tfZet, 240.0);
		AnchorPane.setTopAnchor(tfZet, 600.0);
		rootPane.getChildren().add(tfZet);
		
		Button btnZet = new Button("Zet");
		AnchorPane.setLeftAnchor(btnZet, 300.0);
		AnchorPane.setTopAnchor(btnZet, 600.0);
		rootPane.getChildren().add(btnZet);
		
		btnZet.setOnAction(new EventHandler<ActionEvent>() {
			@Override public void handle(ActionEvent e) 
			{
//System.out.println("button clicked");
				String result = spel.zet(tfZet.getText());
				if (result != null)// geldige zet
				{
					//doe een tegenzet
					spel.doeEenComputerZet();					
					drawBord(draaiBordOm);
				}
			}
		});
	}


	
	public static void main(String[] args) 
	{
		launch(args);
	}



	void drawBord(boolean draaiBordOm)
	{
		for (int r = 0; r < 8; r++)
			for (int k = 0; k < 8; k++)
			{
				int x = (draaiBordOm ? 7 - k : k);
				int y = (draaiBordOm ? 7 - r : r);
				int veldKleur = 1 - (r + k) % 2;
				Stuk stuk = spel.stukAt[r][k];
				if (stuk == null)	
					ivVelden[x][y].setImage(imLeegVeld[veldKleur]);
				else
					ivVelden[x][y].setImage(imStukken[stuk.type][stuk.kleur][veldKleur]);
			}
			
		//print labels "A" t/m "H" en "1" t/m "8" langs het veld		
		for (int r = 0; r < 8; r++)
		{	
			int y = (draaiBordOm ? 7 - r : r);
			rijLabel[y].setText("" + (r + 1) ); 
		}
		for (int k = 0; k < 8; k++)
		{
			int x = (draaiBordOm ? 7 - k : k);
			kolLabel[x].setText("" + (char) ('A' + k) );
		}
			 
	}

}