import java.util.ArrayList;



class Stuk
{
	final static int WIT = 0;
	final static int ZWART = 1;
	
	final static int PION = 0;
	final static int PAARD = 1;
	final static int LOPER = 2;
	final static int TOREN = 3;
	final static int DAME = 4;
	final static int KONING = 5;

	final static String[] typeNamen = new String[]{"pion", "paard", "loper", "toren", "dame", "koning"};

	final static int[] aantPunten = new int[]{ 1, 3, 3, 5, 10, 1000 };

		

	int kleur;
	int type;
	int x, y;
	Spel spel;
	ArrayList<Veld> bereik;
	ArrayList<Veld> bereikInclSchaak;



	Stuk(Spel spel, int kleur, int type, int x, int y)
	{	
		this.spel = spel;
		this.kleur = kleur;
		this.type = type;
		this.x = x;
		this.y = y;
	}



	void bepaalBereik() 
	{
		bereik = new ArrayList<Veld>();
		Stuk[][] stukAt = spel.stukAt;
		Veld[][] velden = Spel.velden;
 
		if (type == Stuk.PION)
		{
			//een pion heeft 4 mogelijkheden: 1 vooruit, 2 vooruit, 1 schuin naar rechts, 1 schuin naar links	
			
			//1 vooruit
			//check of het veld voor de pion vrij is
			int y_1_vooruit = (kleur == WIT ? y + 1 : y - 1);
 			if (stukAt[x][y_1_vooruit] == null)
			{
				bereik.add(velden[x][y_1_vooruit]);

				//2 vooruit
				//check of de pion nog op de startrij staat, en check of ook het veld 2 voor de pion vrij is
				int startRij = (kleur == WIT ? 1 : 6);
				if (y == startRij)
				{
					int y_2_vooruit = (kleur == WIT ? y + 2 : y - 2);
					if (stukAt[x][y_2_vooruit] == null)
						bereik.add(velden[x][y_2_vooruit]);
				}
			}

			//1 schuin naar links (rechts voor zwart)
			if (x > 0)			       //er staat een stuk van de andere dan de eigen kleur
				if (stukAt[x - 1][y_1_vooruit] != null && stukAt[x - 1][y_1_vooruit].kleur != kleur )  
					bereik.add(velden[x - 1][y_1_vooruit]);

			//1 schuin naar rechts (links voor zwart)
			if (x < 7)
				if (stukAt[x + 1][y_1_vooruit] != null && stukAt[x + 1][y_1_vooruit].kleur != kleur )  
					bereik.add(velden[x + 1][y_1_vooruit]);

		}



		if (type == Stuk.PAARD)
		{
			//een paard heeft 8 (max) mogelijkheden. ik behandel ze afzonderlijk met de klok mee

			//2 naar links, 1 naar boven
			if (x > 1 && y < 7)
				if (stukAt[x - 2][y + 1] == null || stukAt[x - 2][y + 1].kleur != kleur)
					bereik.add(velden[x - 2][y + 1]);

			//1 naar links, 2 naar boven
			if (x > 0 && y < 6)
				if (stukAt[x - 1][y + 2] == null || stukAt[x - 1][y + 2].kleur != kleur)
					bereik.add(velden[x - 1][y + 2]);
			
			//1 naar rechts, 2 naar boven
			if (x < 7 && y < 6)
				if (stukAt[x + 1][y + 2] == null || stukAt[x + 1][y + 2].kleur != kleur)
					bereik.add(velden[x + 1][y + 2]);

			//2 naar rechts, 1 naar boven
			if (x < 6 && y < 7)
				if (stukAt[x + 2][y + 1] == null || stukAt[x + 2][y + 1].kleur != kleur)
					bereik.add(velden[x + 2][y + 1]);
			
			//2 naar rechts, 1 naar onder
			if (x < 6 && y > 0)
				if (stukAt[x + 2][y - 1] == null || stukAt[x + 2][y - 1].kleur != kleur)
					bereik.add(velden[x + 2][y - 1]);

			//1 naar rechts, 2 naar onder
			if (x < 7 && y > 1)
				if (stukAt[x + 1][y - 2] == null || stukAt[x + 1][y - 2].kleur != kleur)
					bereik.add(velden[x + 1][y - 2]);
			
			//1 naar links, 2 naar onder
			if (x > 0 && y > 1)
				if (stukAt[x - 1][y - 2] == null || stukAt[x - 1][y - 2].kleur != kleur)
					bereik.add(velden[x - 1][y - 2]);

			//2 naar links, 1 naar onder
			if (x > 1 && y > 0)
				if (stukAt[x - 2][y - 1] == null || stukAt[x - 2][y - 1].kleur != kleur)
					bereik.add(velden[x - 2][y - 1]);
		}



		if (type == Stuk.LOPER || type == Stuk.DAME)
		{
			//een loper kan 4 verschillende richtingen uit, die ik afzonderlijk zal behandelen (met 4 while-loops)

			int tx, ty;  //t=target
			
			//naar links-boven 
			//begin bij het stuk zelf
			tx = x;	 
			ty = y;
			while (tx > 0 && ty < 7) //ga door tot de randen van het bord
			{	
				tx--;
				ty++;
				if (stukAt[tx][ty] == null)
					bereik.add(velden[tx][ty]);
				else
				{
					if (stukAt[tx][ty].kleur != kleur)
						bereik.add(velden[tx][ty]);
					break; // er is een stuk in de loop van de loper in deze richting gekomen. 
				}
			}

			//naar rechts-boven 
			//begin bij het stuk zelf
			tx = x;	 
			ty = y;
			while (tx < 7 && ty < 7) //ga door tot de randen van het bord
			{	
				tx++;
				ty++;
				if (stukAt[tx][ty] == null)
					bereik.add(velden[tx][ty]);
				else
				{
					if (stukAt[tx][ty].kleur != kleur)
						bereik.add(velden[tx][ty]);
					break; // er is een stuk in de loop van de loper in deze richting gekomen. 
				}
			}

			//naar rechts-onder 
			//begin bij het stuk zelf
			tx = x;	 
			ty = y;
			while (tx < 7 && ty > 0) //ga door tot de randen van het bord
			{	
				tx++;
				ty--;
				if (stukAt[tx][ty] == null)
					bereik.add(velden[tx][ty]);
				else
				{
					if (stukAt[tx][ty].kleur != kleur)
						bereik.add(velden[tx][ty]);
					break; // er is een stuk in de loop van de loper in deze richting gekomen. 
				}
			}

			//naar links-onder 
			//begin bij het stuk zelf
			tx = x;	 
			ty = y;
			while (tx > 0 && ty > 0) //ga door tot de randen van het bord
			{	
				tx--;
				ty--;
				if (stukAt[tx][ty] == null)
					bereik.add(velden[tx][ty]);
				else
				{
					if (stukAt[tx][ty].kleur != kleur)
						bereik.add(velden[tx][ty]);
					break; // er is een stuk in de loop van de loper in deze richting gekomen. 
				}
			}
		}
	
	

		if (type == Stuk.TOREN || type == Stuk.DAME)
		{
			//een toren kan 4 verschillende richtingen uit, die ik afzonderlijk zal behandelen (met 4 while-loops)

			int tx, ty;  //t=target

			//naar links;
			//begin bij het stuk zelf
			tx = x;	 
			ty = y;
			while (tx > 0) //ga door tot de rand van het bord
			{
				tx--;
				if (stukAt[tx][ty] == null)
					bereik.add(velden[tx][ty]);
				else
				{
					if (stukAt[tx][ty].kleur != kleur)
						bereik.add(velden[tx][ty]);
					break; // er is een stuk in de loop van de toren in deze richting gekomen. 
				}
			}

			//naar rechts;
			//begin bij het stuk zelf
			tx = x;	 
			ty = y;
			while (tx < 7) //ga door tot de rand van het bord
			{
				tx++;
				if (stukAt[tx][ty] == null)
					bereik.add(velden[tx][ty]);
				else
				{
					if (stukAt[tx][ty].kleur != kleur)
						bereik.add(velden[tx][ty]);
					break; // er is een stuk in de loop van de toren in deze richting gekomen. 
				}
			}

			//naar boven;
			//begin bij het stuk zelf
			tx = x;	 
			ty = y;
			while (ty < 7) //ga door tot de rand van het bord
			{
				ty++;
				if (stukAt[tx][ty] == null)
					bereik.add(velden[tx][ty]);
				else
				{
					if (stukAt[tx][ty].kleur != kleur)
						bereik.add(velden[tx][ty]);
					break; // er is een stuk in de loop van de toren in deze richting gekomen. 
				}
			}

			//naar onder;
			//begin bij het stuk zelf
			tx = x;	 
			ty = y;
			while (ty > 0) //ga door tot de rand van het bord
			{
				ty--;
				if (stukAt[tx][ty] == null)
					bereik.add(velden[tx][ty]);
				else
				{
					if (stukAt[tx][ty].kleur != kleur)
						bereik.add(velden[tx][ty]);
					break; // er is een stuk in de loop van de toren in deze richting gekomen. 
				}
			}

		}

		

		if (type == Stuk.KONING)
		{
			ArrayList<Veld> potBereik = new ArrayList<Veld>(); //potentieel: nog niet gecheckt op schaak
			
			//een koning heeft max 8 mogelijke velden om naar toe te gaan:
			
			//1 naar boven
			if (y < 7)
				if (stukAt[x][y + 1] == null || stukAt[x][y + 1].kleur != kleur)
					potBereik.add(velden[x][y + 1]);
			
			//1 naar onder
			if (y > 0)
				if (stukAt[x][y - 1] == null || stukAt[x][y - 1].kleur != kleur)
					potBereik.add(velden[x][y - 1]);
			
			//1 naar rechts
			if (x < 7)
				if (stukAt[x + 1][y] == null || stukAt[x + 1][y].kleur != kleur)
					potBereik.add(velden[x + 1][y]);
			
			//1 naar links
			if (x > 0)
				if (stukAt[x - 1][y] == null || stukAt[x - 1][y].kleur != kleur)
					potBereik.add(velden[x - 1][y]);
						
			//1 naar linksboven
			if (x > 0 && y < 7)
				if (stukAt[x - 1][y + 1] == null || stukAt[x - 1][y + 1].kleur != kleur)
					potBereik.add(velden[x - 1][y + 1]);
			
			//1 naar rechtsboven
			if (x < 7 && y < 7)
				if (stukAt[x + 1][y + 1] == null || stukAt[x + 1][y + 1].kleur != kleur)
					potBereik.add(velden[x + 1][y + 1]);

			//1 naar linksonder
			if (x > 0 && y > 0)
				if (stukAt[x - 1][y - 1] == null || stukAt[x - 1][y - 1].kleur != kleur)
					potBereik.add(velden[x - 1][y - 1]);
			
			//1 naar rechtsonder
			if (x < 7 && y > 0)
				if (stukAt[x + 1][y - 1] == null || stukAt[x + 1][y - 1].kleur != kleur)
					potBereik.add(velden[x + 1][y - 1]);
		
			//check op schaak gebeurt elders
			bereik = potBereik;



			//check op rokade //ik voer niet alle officiele checks/voorwaarden uit, alleen de belangrijkste
			
			//veld vd koning moet gelijk zijn aan het start-veld. (officieel mag de koning nog niet bewogen hebben)
			if (x == 4 && ( (kleur == WIT && y == 0) || (kleur == ZWART && y == 7) ))
			{
				//check op lange rokade
				Stuk toren = stukAt[0][y]; 
				//er moet een toren op A1/A8 staan van de eigen kleur
				if (toren != null && toren.type == TOREN && toren.kleur == kleur)
				{
					//de velden tussen de koning en de toren moeten leeg zijn
					boolean rokade_kan = true;
					for (int k = 1; k <= 3; k++)
						if (stukAt[k][y] != null)
							rokade_kan = false; 
					if (rokade_kan) 
					{
						//System.out.println("lange rokade kan");
						bereik.add(velden[2][y]);		
//is het wel handig om de rokade toe te voegen aan de "bereik"-variabele??? 2 aparte booleans is misschien beter
					}
				}

				//check op korte rokade
				toren = stukAt[7][y]; 
				//er moet een toren op H1/H8 staan van de eigen kleur
				if (toren != null && toren.type == TOREN && toren.kleur == kleur)
				{
					//de velden tussen de koning en de toren moeten leeg zijn
					boolean rokade_kan = true;
					for (int k = 5; k <= 6; k++)
						if (stukAt[k][y] != null)
							rokade_kan = false; 
					if (rokade_kan) 
					{
						//System.out.println("korte rokade kan");
						bereik.add(velden[6][y]);
					}
				}		
		
			
			}
		}

				
	}

		
	
	void bepaalBereikInclSchaak()
	{
		bereikInclSchaak = new ArrayList<Veld>();
	
		for (Veld veld : bereik)
			if (!(spel.staatSchaakNaZet(x, y, veld.x, veld.y)))
				bereikInclSchaak.add(veld);		
	}



	static boolean bereikContains(ArrayList<Veld> bereik, Veld veld)
	{
		for (Veld b_veld : bereik)
			if (veld.x == b_veld.x && veld.y == b_veld.y)
				return true;
		return false;
	}



	//voor testing
	void print()
	{
		System.out.print(typeNamen[type]);
	}
 


	//voor testing
	void printBereik()
	{
		for (Veld veld : bereik)
			System.out.print("[" + veld.x + "," + veld.y + "] ");
	}
}