import java.util.ArrayList;



class Spel 
{
	Stuk[][] stukAt;
	
	Stuk[] stukken;
	int aantStukken;
	
	int adb;	

	static Veld[][] velden;

	

	
	
	static void init()
	{
		velden = new Veld[8][8];
		for (int x = 0; x < 8; x++)
			for (int y = 0; y < 8; y++)
				velden[x][y] = new Veld(x, y); 
	}



	Spel()
	{
		stukAt = new Stuk[8][8];
		stukken = new Stuk[32];
		aantStukken = 0;

		addStuk(Stuk.WIT, Stuk.TOREN, 0, 0);
		addStuk(Stuk.WIT, Stuk.PAARD, 1, 0);
		addStuk(Stuk.WIT, Stuk.LOPER, 2, 0);
		addStuk(Stuk.WIT, Stuk.DAME, 3, 0);
		addStuk(Stuk.WIT, Stuk.KONING, 4, 0);
		addStuk(Stuk.WIT, Stuk.LOPER, 5, 0);
		addStuk(Stuk.WIT, Stuk.PAARD, 6, 0);
		addStuk(Stuk.WIT, Stuk.TOREN, 7, 0);
		addStuk(Stuk.WIT, Stuk.PION, 0, 1);
		addStuk(Stuk.WIT, Stuk.PION, 1, 1);
		addStuk(Stuk.WIT, Stuk.PION, 2, 1);
		addStuk(Stuk.WIT, Stuk.PION, 3, 1);
		addStuk(Stuk.WIT, Stuk.PION, 4, 1);
		addStuk(Stuk.WIT, Stuk.PION, 5, 1);
		addStuk(Stuk.WIT, Stuk.PION, 6, 1);
		addStuk(Stuk.WIT, Stuk.PION, 7, 1);
		addStuk(Stuk.ZWART, Stuk.TOREN, 0, 7);
		addStuk(Stuk.ZWART, Stuk.PAARD, 1, 7);
		addStuk(Stuk.ZWART, Stuk.LOPER, 2, 7);
		addStuk(Stuk.ZWART, Stuk.DAME, 3, 7);
		addStuk(Stuk.ZWART, Stuk.KONING, 4, 7);
		addStuk(Stuk.ZWART, Stuk.LOPER, 5, 7);
		addStuk(Stuk.ZWART, Stuk.PAARD, 6, 7);
		addStuk(Stuk.ZWART, Stuk.TOREN, 7, 7);
		addStuk(Stuk.ZWART, Stuk.PION, 0, 6);
		addStuk(Stuk.ZWART, Stuk.PION, 1, 6);
		addStuk(Stuk.ZWART, Stuk.PION, 2, 6);
		addStuk(Stuk.ZWART, Stuk.PION, 3, 6);
		addStuk(Stuk.ZWART, Stuk.PION, 4, 6);
		addStuk(Stuk.ZWART, Stuk.PION, 5, 6);
		addStuk(Stuk.ZWART, Stuk.PION, 6, 6);
		addStuk(Stuk.ZWART, Stuk.PION, 7, 6);
		
		adb = Stuk.WIT;
	}	



	Spel(Spel or_spel) //maak een kopie van het Spel (waarmee bvb vooruitgedacht/-gespeeld kan worden)
	{
		stukAt = new Stuk[8][8];
		stukken = new Stuk[32];
		aantStukken = 0;
	
		for (int s = 0; s < or_spel.aantStukken; s++)
			addStuk(or_spel.stukken[s].kleur, or_spel.stukken[s].type, or_spel.stukken[s].x, or_spel.stukken[s].y);	
		
		this.adb = or_spel.adb; 
		//bereik ook kopieren?
	}	


	
	void addStuk(int kleur, int type, int x, int y)
	{
		Stuk stuk = new Stuk(this, kleur, type, x, y);
		stukken[aantStukken] = stuk;
		stukAt[x][y] = stuk;
		aantStukken++;
	}



	//return null bij ongeldige zet
	public String zet(String strZet)  //bvb "d2d4"
	{
		if (strZet.length() < 4)
			return null;
		
		char ch_x_van = strZet.charAt(0);
		if (ch_x_van < 'a' || ch_x_van > 'h')
			return null;
		int x_van = ch_x_van - 'a'; 
   		
		char ch_y_van = strZet.charAt(1);
		if (ch_y_van < '1' || ch_y_van > '8')
			return null;
		int y_van = ch_y_van - '1';
		
		char ch_x_naar = strZet.charAt(2);
		if (ch_x_naar < 'a' || ch_x_naar > 'h')
			return null;
		int x_naar = ch_x_naar - 'a';
		
		char ch_y_naar = strZet.charAt(3);
		if (ch_y_naar < '1' || ch_y_naar > '8')
			return null;
		int y_naar = ch_y_naar - '1';
		
		return zet(x_van, y_van, x_naar, y_naar);
	}



	//check user-zet op geldigheid, en voer m dan uit
	public String zet(int x_van, int y_van, int x_naar, int y_naar)
	{
		if (stukAt[x_van][y_van] == null)
			return null;
		
		if (x_van == x_naar && y_van == y_naar)
			return null;

		if (stukAt[x_van][y_van].kleur != adb)
			return null;

		// ( check op rokade gebeurt in bepaalBereik() )

		stukAt[x_van][y_van].bepaalBereik();
		if (!(Stuk.bereikContains(stukAt[x_van][y_van].bereik, velden[x_naar][y_naar])))
			return null; 
/*
System.out.print("bereik: ");
stukAt[x_van][y_van].printBereik();
System.out.println();
*/

		if (staatSchaakNaZet(x_van, y_van, x_naar, y_naar))
			return null;

		move(x_van, y_van, x_naar, y_naar);

		adb = 1 - adb; //de andere speler is nu aan de beurt	
		return "";
	}



	void move(int x_van, int y_van, int x_naar, int y_naar)
	{
		Stuk stuk = stukAt[x_van][y_van];


//System.out.println("move: [" + x_van + "," + y_van + "] --> [" + x_naar + "," + y_naar + "]");
/*
		if (stuk == null)
			return;
		
		if (x_van == x_naar && y_van == y_naar)
			return;
*/	


		//check op rokade
		if (stuk.type == Stuk.KONING && (x_van - x_naar == 2 || x_van - x_naar == -2))
		{
			Zet toren_move = get2ndRokadeMove(x_van, y_van, x_naar, y_naar);
			move(toren_move.x_van, toren_move.y_van, toren_move.x_naar, toren_move.y_naar); 	
		}

			

		if (stukAt[x_naar][y_naar] != null)  //als er een ander stuk geslagen wordt...
			removeStuk(x_naar, y_naar);
		
		stukAt[x_naar][y_naar] = stuk;
		
		stuk.x = x_naar;
		stuk.y = y_naar;

		stukAt[x_van][y_van] = null;

		//check op pion-promotie (wordt altijd een dame, voor het gemak)
		if (stuk.type == Stuk.PION && (y_naar == 0 || y_naar == 7))
		{
			stuk.type = Stuk.DAME;	
		}
	}



	boolean staatSchaakNaZet(int x_van, int y_van, int x_naar, int y_naar)
	{
		int adb = stukAt[x_van][y_van].kleur;
	
		Spel tkSpel = new Spel(this); //toekomstig spel 
		tkSpel.move(x_van, y_van, x_naar, y_naar);
		tkSpel.bepaalAlleBereiken();
	
		//get veld koning
		Veld veldKoning = null;
		for (int s = 0; s < tkSpel.aantStukken; s++)
		{	
			Stuk stuk = tkSpel.stukken[s];
			if (stuk.kleur == adb && stuk.type == Stuk.KONING)
			{	
				veldKoning = velden[stuk.x][stuk.y];
				break;
			}
		}

		//als de koning zich in het bereik van een van de stukken van de tegenspeler bevindt, dan is het schaak.		
		for (int s = 0; s < tkSpel.aantStukken; s++)
		{	
			Stuk stuk = tkSpel.stukken[s];
 			if (stuk.kleur == 1 - adb && Stuk.bereikContains(stuk.bereik, veldKoning))
				return true;
		}
		return false;
	}	

	

	Zet get2ndRokadeMove(int x_van, int y_van, int x_naar, int y_naar) // parameters zijn de move van de koning
	{
		return new Zet(
			(x_naar == 2 ? 0 : 7),
			y_van,
			(x_naar == 2 ? 3 : 5),
			y_naar 
		);	
	}	



	void removeStuk(int x, int y)
	{
		int stukIndex = 0;
		while (stukIndex < aantStukken)
		{
			if (x == stukken[stukIndex].x && y == stukken[stukIndex].y)
				break;
			stukIndex++;
		}

		for (int i = stukIndex; i < aantStukken - 1; i++)
			stukken[i] = stukken[i + 1];
		aantStukken--;
	}



	void bepaalAlleBereiken()
	{
		for (int s = 0; s < aantStukken; s++)
			stukken[s].bepaalBereik();
	}



	
	void doeEenWillekeurigeZet()
	{
		bepaalAlleBereiken();  //eigenlijk alleen die van de eigen kleur nodig

		ArrayList<Zet> moglZetten = new ArrayList<Zet>();
		
		for (int s = 0; s < aantStukken; s++)
			if (stukken[s].kleur == adb)
				for (Veld target_veld : stukken[s].bereik)
					moglZetten.add(new Zet(stukken[s].x, stukken[s].y, target_veld.x, target_veld.y));
//System.out.println(moglZetten.size());

		Zet zet;
		do 
		{
			int zetIndex = (int)(moglZetten.size() * Math.random());
			zet = moglZetten.get(zetIndex);			
			//throws IndexOutOfBoundsException bij pat (leeg bereik)?

		}
		while (staatSchaakNaZet(zet.x_van, zet.y_van, zet.x_naar, zet.y_naar)); //moglZetten waren nog niet gecheckt op schaak
		//eeuwige loop bij mat	
	
		move(zet.x_van, zet.y_van, zet.x_naar, zet.y_naar);

		adb = 1 - adb; //de andere speler is nu aan de beurt	
	}



	//voor testing
	void printStukken()
	{
		for (int i = 0; i < aantStukken; i++)
		{	
			stukken[i].print();
			System.out.print(":   ");
			stukken[i].printBereik();
			System.out.println();
		}
			
		System.out.println();
	}



	

}