class Figuur
{
	final static Pos[][][] possss = new Pos[][][]{
		{ 
			{new Pos(1, 0), new Pos(1, 1), new Pos(1, 2), new Pos(2, 2)},
			{new Pos(3, 1), new Pos(2, 1), new Pos(1, 1), new Pos(1, 2)},
			{new Pos(2, 2), new Pos(2, 1), new Pos(2, 0), new Pos(1, 0)},
			{new Pos(0, 2), new Pos(1, 2), new Pos(2, 2), new Pos(2, 1)} 
		},
		{ 
			{new Pos(2, 0), new Pos(2, 1), new Pos(2, 2), new Pos(1, 2)},
			{new Pos(3, 2), new Pos(2, 2), new Pos(1, 2), new Pos(1, 1)},
			{new Pos(1, 2), new Pos(1, 1), new Pos(1, 0), new Pos(2, 0)},
			{new Pos(0, 1), new Pos(1, 1), new Pos(2, 1), new Pos(2, 2)} 
		},
		{ 
			{new Pos(1, 0), new Pos(1, 1), new Pos(1, 2), new Pos(1, 3)},
			{new Pos(0, 1), new Pos(1, 1), new Pos(2, 1), new Pos(3, 1)},
			{new Pos(1, 0), new Pos(1, 1), new Pos(1, 2), new Pos(1, 3)},
			{new Pos(0, 1), new Pos(1, 1), new Pos(2, 1), new Pos(3, 1)} 
		},
		{ 
			{new Pos(1, 0), new Pos(2, 0), new Pos(1, 1), new Pos(2, 1)},
			{new Pos(1, 0), new Pos(2, 0), new Pos(1, 1), new Pos(2, 1)},
			{new Pos(1, 0), new Pos(2, 0), new Pos(1, 1), new Pos(2, 1)},
			{new Pos(1, 0), new Pos(2, 0), new Pos(1, 1), new Pos(2, 1)} 
		},
		{ 
			{new Pos(1, 0), new Pos(0, 1), new Pos(1, 1), new Pos(2, 1)},
			{new Pos(2, 1), new Pos(1, 0), new Pos(1, 1), new Pos(1, 2)},
			{new Pos(1, 2), new Pos(2, 1), new Pos(1, 1), new Pos(0, 1)},
			{new Pos(0, 1), new Pos(1, 2), new Pos(1, 1), new Pos(1, 0)} 
		},
		{ 
			{new Pos(1, 0), new Pos(1, 1), new Pos(2, 1), new Pos(2, 2)},
			{new Pos(2, 0), new Pos(1, 0), new Pos(1, 1), new Pos(0, 1)},
			{new Pos(1, 0), new Pos(1, 1), new Pos(2, 1), new Pos(2, 2)},
			{new Pos(2, 0), new Pos(1, 0), new Pos(1, 1), new Pos(0, 1)} 
		},
		{ 
			{new Pos(2, 0), new Pos(2, 1), new Pos(1, 1), new Pos(1, 2)},
			{new Pos(0, 0), new Pos(1, 0), new Pos(1, 1), new Pos(2, 1)},
			{new Pos(2, 0), new Pos(2, 1), new Pos(1, 1), new Pos(1, 2)},
			{new Pos(0, 0), new Pos(1, 0), new Pos(1, 1), new Pos(2, 1)} 
		}
	};
	

	Tetris tetris;
	int type;
	int x, y;
	Pos[] poss;   	//positie(absoluut) van de current hoek
	Pos[][] posss;	//posities(relatief) van alle hoeken
	int hoek;


	
	Figuur(Tetris tetris, int type)
	{
		this.tetris = tetris;
		this.type = type;
		hoek = -1;
		posss = possss[type]; 
	}



	void addToNextField()
	{
		//wis het oude figuur, wis het hele veld
		for (int x = 0; x < 4; x++)
			for (int y = 0; y < 4; y++)
				tetris.nextField[x][y].setVisible(false);

		//plaats het nieuwe figuur
		for (int i = 0; i < 4; i++)
			 tetris.nextField[posss[0][i].x][posss[0][i].y].setVisible(true);
	}
	
	
		
	void addToBord()
	{
		x = tetris.aantKol / 2 - 2;
		y = 0;

		poss = new Pos[4];
		for (int i = 0; i < 4; i++)
			poss[i] = new Pos(x + posss[0][i].x, y + posss[0][i].y);
		
		if (!setHoek(0))  
		{	
			tetris.drawFiguur(this, true); //eigenlijk figuur nog tekenen?  
			tetris.einde = true;
			tetris.timer.cancel();
		}
		
				
	}
	



	boolean setHoek(int new_hoek)
	{	
		Pos[] newPoss = new Pos[4];
		for (int i = 0; i < 4; i++)
		{
			newPoss[i] = new Pos(x + posss[new_hoek][i].x, y + posss[new_hoek][i].y);
			if (newPoss[i].x < 0)  //botst met linker zijkant
				return false;
			if (newPoss[i].x >= tetris.aantKol)  //botst met rechter zijkant
				return false;
			if (newPoss[i].y >= tetris.aantRij)  //botst met bodem
				return false;
			if (tetris.blokAt[newPoss[i].x][newPoss[i].y])   //botst met ander blok
				return false;
		}
		
		if (hoek >= 0)
			//"undraw" current figure
			tetris.drawFiguur(this, false);
		
		poss = newPoss;
		hoek = new_hoek;
		
		tetris.drawFiguur(this, true);
		
		return true;
	}

	
	
	void rotate()
	{
		setHoek((hoek + 1) % 4);
	}

	
	
	void moveDown()
	{
		Pos[] newPoss = new Pos[4];
		for (int i = 0; i < 4; i++)
		{
			newPoss[i] = new Pos(poss[i].x, poss[i].y + 1);
			if (newPoss[i].y == tetris.aantRij)  //botst met bodem
			{
				eindeFiguur();
				return;
			}
			if (tetris.blokAt[newPoss[i].x][newPoss[i].y])   //botst met ander blok
			{
				eindeFiguur();
				return;
			}
		}
		
		tetris.drawFiguur(this, false);

		poss = newPoss;
		y++;
					
		tetris.drawFiguur(this, true);
	}

	
	
	void eindeFiguur()
	{
		for (int i = 0; i < 4; i++)
			tetris.setVeld(poss[i].x, poss[i].y, true);
		
		//check op complete rijen
		for (int rij = y; rij < y + 4 && rij < tetris.aantRij; rij++)
		{
			boolean completeRij = true;
			for (int kol = 0; kol < tetris.aantKol; kol++)
				if (!tetris.blokAt[kol][rij])
					{ completeRij = false;   break; }
			if (completeRij)
			{	
				//kopieer elke rij naar de onderstaande rij
				for (int r = rij; r > 0; r--)
					for (int k = 0; k < tetris.aantKol; k++)
						tetris.setVeld(k, r, tetris.blokAt[k][r - 1]);
				//maak de bovenste rij leeg
				for (int k = 0; k < tetris.aantKol; k++)
					tetris.setVeld(k, 0, false);		

				tetris.setScore(tetris.score + 1);		
			}
		}

		tetris.figuur = tetris.nextFiguur;
		tetris.figuur.addToBord(); 
		tetris.nextFiguur = new Figuur(tetris, (int)(Math.random() * possss.length));
		tetris.nextFiguur.addToNextField();			
	}

		
	
	void moveLeft()
	{
		Pos[] newPoss = new Pos[4];
		for (int i = 0; i < 4; i++)
		{
			newPoss[i] = new Pos(poss[i].x - 1, poss[i].y);
			if (newPoss[i].x == -1)  //botst met zijkant
				return;
			if (tetris.blokAt[newPoss[i].x][newPoss[i].y])   //botst met ander blok
				return;
		}
		
		tetris.drawFiguur(this, false);

		poss = newPoss;
		x--;
					
		tetris.drawFiguur(this, true);
	
	}



	void moveRight()
	{
		Pos[] newPoss = new Pos[4];
		for (int i = 0; i < 4; i++)
		{
			newPoss[i] = new Pos(poss[i].x + 1, poss[i].y);
			if (newPoss[i].x == tetris.aantKol)  //botst met zijkant
				return;
			if (tetris.blokAt[newPoss[i].x][newPoss[i].y])   //botst met ander blok
				return;
		}
		
		tetris.drawFiguur(this, false);

		poss = newPoss;
		x++;
					
		tetris.drawFiguur(this, true);
	
	}

}