import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.stage.Stage;



public class Tetris extends Application 
{
	int aantRij = 20;
	int aantKol = 12;
	int blokWidth = 25;

	int timerInterval = 200;

	Figuur figuur, nextFiguur;
	AnchorPane rootPane;
	
	boolean[][] blokAt;
	Rectangle[][] velden;	

	Rectangle[][] nextField;
	int score;
	Text txtScore;
	Timer timer;
	boolean pauze;
	boolean einde;



	@Override
	public void start(Stage stage) throws Exception {
		rootPane = new AnchorPane();
		
		blokAt = new boolean[aantKol][aantRij]; 
		velden = new Rectangle[aantKol][aantRij];
		
		for (int x = 0; x < aantKol; x++)
			for (int y = 0; y < aantRij; y++)
			{
				Rectangle veld = new Rectangle(blokWidth, blokWidth);
				AnchorPane.setLeftAnchor(veld, 50.0 + x * blokWidth);
				AnchorPane.setTopAnchor(veld, 50.0 + y * blokWidth);
				veld.setFill(Color.BLACK);
				velden[x][y] = veld;
				setVeld(x, y, false);
				rootPane.getChildren().add(veld);						
			}
	 
		nextField = new Rectangle[4][4];
		for (int x = 0; x < 4; x++)
			for (int y = 0; y < 4; y++)
			{
				Rectangle veld = new Rectangle(blokWidth, blokWidth);
				AnchorPane.setLeftAnchor(veld, 50.0 + (aantKol +  x + 1) * blokWidth);
				AnchorPane.setTopAnchor(veld, 50.0 + y * blokWidth);
				veld.setFill(Color.BLACK);
				veld.setVisible(false);
				rootPane.getChildren().add(veld);
				nextField[x][y] = veld;						
			}	
	
		txtScore = new Text();		
		AnchorPane.setLeftAnchor(txtScore, 50.0);
		AnchorPane.setTopAnchor(txtScore, 30.0);
		rootPane.getChildren().add(txtScore);
		setScore(0);

		figuur = new Figuur(this, (int)(Math.random() * Figuur.possss.length));
		figuur.addToBord();

		nextFiguur = new Figuur(this, (int)(Math.random() * Figuur.possss.length));
		nextFiguur.addToNextField();

		//figuur.rotate();
		//figuur.rotate();
		//figuur.rotate();
		//drawFiguur(figuur0, true);

		Rectangle kader = new Rectangle(aantKol * blokWidth, aantRij * blokWidth);
		kader.setStroke(Color.BLACK);
		kader.setFill(null);
		AnchorPane.setLeftAnchor(kader, 50.0);
		AnchorPane.setTopAnchor(kader, 50.0);
		rootPane.getChildren().add(kader);		

		Scene scene = new Scene(rootPane, 600, 600,
			Color.WHITE);
		
		scene.setOnKeyPressed(new EventHandler<KeyEvent>() {
            		@Override
            		public void handle(KeyEvent event) 
			{
                		verwerkKeyEvent(event.getCode());
                    	}
                });
		
		stage.setTitle("Tetris");
		stage.setScene(scene);
		stage.show();
		
		pauze = false;
		einde = false;
		timer = new Timer();
		timer.scheduleAtFixedRate(new TimerTask() {
			@Override
			public void run() {
				Platform.runLater(() -> {
					if (!pauze)	
    						figuur.moveDown();
	  			});
			}
		}, 1000, timerInterval);
	}



	@Override
	public void stop() 
	{
        	timer.cancel();
    	}



	void setFiguurVeld(int x, int y, boolean blok)
	{	
		velden[x][y].setVisible(blok);
	}
	


	void setVeld(int x, int y, boolean blok)
	{
		blokAt[x][y] = blok;
		velden[x][y].setVisible(blok);
	}



	void drawFiguur(Figuur figuur, boolean draw)
	{	
		for (int i = 0; i < figuur.poss.length; i++)
			setFiguurVeld(figuur.poss[i].x, figuur.poss[i].y, draw);
	}



	void verwerkKeyEvent(KeyCode key)
	{	
		if (!einde && !pauze)
		{
			if (key == KeyCode.UP)
				figuur.rotate();
			if (key == KeyCode.DOWN)
				figuur.moveDown();
			if (key == KeyCode.LEFT)
				figuur.moveLeft();
			if (key == KeyCode.RIGHT)
				figuur.moveRight();
		}
		if (key == KeyCode.P)
			pauze = !pauze;		
	}



	void setScore(int new_score)
	{
		score = new_score;
		txtScore.setText("" + score); 
	}



	public static void main(String[] args) 
	{
		launch(args);
	}

}