import java.util.ArrayList;



public class ComputerBeurt
{
	Rummikub rk;
	Speler adb;
	Tafel tafel;
	Veld[][] velden;
	ArrayList<RSet> sets;



	public ComputerBeurt(Rummikub rk)
	{
		this.rk = rk;
		this.adb = rk.adb;
		this.tafel = rk.tafel;
		this.velden = tafel.velden;
		if (rk.sets == null)
			rk.sets = new ArrayList<RSet>();
		this.sets = rk.sets;

		NummersSet nummersSet = zoekNummersSet();
		while (nummersSet != null) 
		{
			sets.add(nummersSet);
			addRijtjeToTafel(nummersSet.stenen);
			nummersSet = zoekNummersSet(); //NB hij begint telkens weer van vooraf aan met zoeken, maar ik let niet op performance
		}

		KleurenSet kleurenSet = zoekKleurenSet();
		while (kleurenSet != null) 
		{
			sets.add(kleurenSet);
			addRijtjeToTafel(kleurenSet.stenen);
			kleurenSet = zoekKleurenSet();
		}

		zoekInwisselbareJokers();

		while (legAan());
					
	}

	

	void addRijtjeToTafel(ArrayList<Steen> stenen)
	{
		int aantStenen = stenen.size();
		Pos eersteVeld = tafel.zoekLegePlek(aantStenen);
		
		rk.steenWeggelegd = true; 
		
		for (int s = 0; s < aantStenen; s++)
		{
			Steen steen = stenen.get(s);
			for (int i = 0; i < adb.stenen.size(); i++)
				if (adb.stenen.get(i).id == steen.id)
					adb.stenen.remove(i);
			
			velden[steen.y][steen.x].setSteen(null);
			velden[eersteVeld.y][eersteVeld.x + s].setSteen(steen);			
		}
	}



	NummersSet zoekNummersSet()
	{
		for (int kleur = 0; kleur < 4; kleur++)
			for (int startNr = 1; startNr <= 11; startNr++)
			{
				//we zoeken alleen naar rijtjes van 3
				Steen steen1 = zoekSteenOpBordje(kleur, startNr);
				Steen steen2 = zoekSteenOpBordje(kleur, startNr + 1);
				Steen steen3 = zoekSteenOpBordje(kleur, startNr + 2); 
				// niet op performance gelet: steen 2 en 3 eigenlijk niet zoeken als 1 = null
				if (steen1 != null && steen2 != null && steen3 != null)
				{
					NummersSet nrsSet = new NummersSet();	
					nrsSet.kleur = kleur;
					nrsSet.eersteNummer = startNr;
					nrsSet.stenen = new ArrayList<Steen>();
					nrsSet.stenen.add(steen1);
					nrsSet.stenen.add(steen2);
					nrsSet.stenen.add(steen3);
					return nrsSet;
				}	
			}

		return null; 
	}



	KleurenSet zoekKleurenSet()
	{
		for (int nummer = 1; nummer <= 13; nummer++) 
		{
			volgendeSkipKleur:
			for (int skipKleur = 0; skipKleur < 4; skipKleur++)    //kijk naar alle 4 de kleuren behalve skipKleur	
			{
				ArrayList<Steen> stenen = new ArrayList<Steen>();
				for (int kleur = 0; kleur < 4; kleur++)
				{
					if (kleur == skipKleur)
						continue;
					Steen steen = zoekSteenOpBordje(kleur, nummer);
					if (steen == null)
						continue volgendeSkipKleur;
					else
						stenen.add(steen);					
				}  
				
				KleurenSet klrSet = new KleurenSet();
				klrSet.nummer = nummer;
				klrSet.stenen = stenen;
				return klrSet;
			}
		}
		return null;
	}



	Steen zoekSteenOpBordje(int kleur, int nummer)
	{
		for (Steen steen : adb.stenen)
			if (kleur == steen.kleur && nummer == steen.nummer)
				return steen;
		return null;
	}



	boolean legAan()
	{	
		for (RSet set : sets)
		{
			if (set instanceof KleurenSet)
			{	
				//probeer aanleggen bij een kleurenSet

				KleurenSet klrSet = (KleurenSet)set;
				ISteen aanlegbareSteen = klrSet.getAanlegbareSteen();
				if (aanlegbareSteen == null)
					continue;
				Steen steen = zoekSteenOpBordje(aanlegbareSteen.kleur, aanlegbareSteen.nummer);
				if (steen != null)
				{	
					//x en y van de aan te leggen steen
					int x = -1;
					int y = klrSet.stenen.get(0).y;
					boolean vooraanToevoegen = false;

					if (pastToevoegen(klrSet, false))
						x = klrSet.stenen.get(0).x + klrSet.stenen.size();
					else if (pastToevoegen(klrSet, true))
					{
						x = klrSet.stenen.get(0).x - 1;
						vooraanToevoegen = true;
					}
					if (!pastToevoegen(klrSet, false) && !pastToevoegen(klrSet, true))
					{	
						//verplaats huidige set naar elders
						Pos eersteVeld = tafel.zoekLegePlek(klrSet.stenen.size() + 1);
						for (int s = 0; s < klrSet.stenen.size(); s++)
						{
							Steen setSteen = klrSet.stenen.get(s);
							velden[setSteen.y][setSteen.x].setSteen(null);
							velden[eersteVeld.y][eersteVeld.x + s].setSteen(setSteen);			
						}
	
						x = eersteVeld.x + klrSet.stenen.size(); 
						y = eersteVeld.y;
					}

					//verplaats steen van bordje naar veld

					for (int i = 0; i < adb.stenen.size(); i++)
						if (adb.stenen.get(i).id == steen.id)
							adb.stenen.remove(i);
			
					velden[steen.y][steen.x].setSteen(null);
					velden[y][x].setSteen(steen);			
					
					klrSet.addSteen(steen, vooraanToevoegen);
rk.checkConsistentie(1);
					rk.steenWeggelegd = true;
					return true;
				} 
			}
		


			if (set instanceof NummersSet)
			{
				NummersSet nrsSet = (NummersSet)set;
	
				//probeer aanleggen vooraan bij een nummersSet

				ISteen aanlegbareSteen = nrsSet.getAanlegbareSteenVooraan();
				if (aanlegbareSteen != null)
				{
					Steen steen = zoekSteenOpBordje(aanlegbareSteen.kleur, aanlegbareSteen.nummer);
					if (steen != null)
					{
						//x en y van de aan te leggen steen
						int x = -1;
						int y = -1;
						
						if (pastToevoegen(nrsSet, true)) 
						{
							x = nrsSet.stenen.get(0).x - 1;
							y = nrsSet.stenen.get(0).y;
						}
						else
						{
							//verplaats huidige set naar elders
							Pos eersteVeld = tafel.zoekLegePlek(nrsSet.stenen.size() + 1);
							for (int s = 0; s < nrsSet.stenen.size(); s++)
							{
								Steen setSteen = nrsSet.stenen.get(s);
								velden[setSteen.y][setSteen.x].setSteen(null);
								velden[eersteVeld.y][eersteVeld.x + s + 1].setSteen(setSteen);		
							}
	
							x = eersteVeld.x; 
							y = eersteVeld.y;
						}
					
						//verplaats steen van bordje naar veld

						for (int i = 0; i < adb.stenen.size(); i++)
							if (adb.stenen.get(i).id == steen.id)
								adb.stenen.remove(i);
			
						velden[steen.y][steen.x].setSteen(null);
						velden[y][x].setSteen(steen);			
						
						nrsSet.addSteen(steen, true);
rk.checkConsistentie(2);
						rk.steenWeggelegd = true;
						return true;
					}	
				}



				//probeer aanleggen achteraan bij een nummersSet

				aanlegbareSteen = nrsSet.getAanlegbareSteenAchteraan();
				if (aanlegbareSteen != null)
				{
					Steen steen = zoekSteenOpBordje(aanlegbareSteen.kleur, aanlegbareSteen.nummer);
					if (steen != null)
					{
						//x en y van de aan te leggen steen
						int x = -1;
						int y = -1;
						
						if (pastToevoegen(nrsSet, false)) 
						{
							x = nrsSet.stenen.get(0).x + nrsSet.stenen.size();
							y = nrsSet.stenen.get(0).y;
						}
						else
						{
							//verplaats huidige set naar elders
							Pos eersteVeld = tafel.zoekLegePlek(nrsSet.stenen.size() + 1);
							for (int s = 0; s < nrsSet.stenen.size(); s++)
							{
								Steen setSteen = nrsSet.stenen.get(s);
								velden[setSteen.y][setSteen.x].setSteen(null);
								velden[eersteVeld.y][eersteVeld.x + s].setSteen(setSteen);			
							}
	
							x = eersteVeld.x + nrsSet.stenen.size(); 
							y = eersteVeld.y;
						}
						
						//verplaats steen van bordje naar veld

						for (int i = 0; i < adb.stenen.size(); i++)
							if (adb.stenen.get(i).id == steen.id)
								adb.stenen.remove(i);
			
						velden[steen.y][steen.x].setSteen(null);
						velden[y][x].setSteen(steen);			
					
						nrsSet.addSteen(steen, false);
rk.checkConsistentie(3);
						rk.steenWeggelegd = true;
						return true;
					}
				}
			}
			//ignore AmbiSets   if (set instanceof AmbiSet)
		}
		


		//probeer invoegen in nummersSet

		for (Steen steen : adb.stenen)
		{
			for (RSet set : sets)
			{
				if (!(set instanceof NummersSet))
					continue;
				NummersSet nrsSet = (NummersSet)set;
				if (nrsSet.kleur != steen.kleur)
					continue;
				int laatsteNummer = nrsSet.eersteNummer + nrsSet.stenen.size() - 1;
				if (!(steen.nummer >= nrsSet.eersteNummer + 2 && steen.nummer <= laatsteNummer - 2))
					continue;   //dan kan deze steen niet in deze nummersSet worden ingevoegd
				
				//splits de bestaande nummersSet in 2 delen
				NummersSet nrsSet1 = new NummersSet();
				nrsSet1.kleur = nrsSet.kleur;
				nrsSet1.eersteNummer = nrsSet.eersteNummer;
				nrsSet1.stenen = new ArrayList<Steen>();
				int ind = 0;
				for (int nr = nrsSet.eersteNummer; nr < steen.nummer; nr++)
				{	
					nrsSet1.stenen.add(nrsSet.stenen.get(ind));
					ind++;
				}
				nrsSet1.stenen.add(steen);

				NummersSet nrsSet2 = new NummersSet();
				nrsSet2.kleur = nrsSet.kleur;
				nrsSet2.eersteNummer = steen.nummer;
				nrsSet2.stenen = new ArrayList<Steen>();				
				for (int nr = steen.nummer; nr <= laatsteNummer; nr++)
				{	
					nrsSet2.stenen.add(nrsSet.stenen.get(ind));
					ind++;
				}

				//verwijder steen van bordje
				for (int i = 0; i < adb.stenen.size(); i++)
					if (adb.stenen.get(i).id == steen.id)
						adb.stenen.remove(i);
				velden[steen.y][steen.x].setSteen(null);
				
				//verwijder oude set van veld
				for (Steen st : nrsSet.stenen)
					velden[st.y][st.x].setSteen(null);

				//voeg nieuwe sets toe aan veld
				Pos eersteVeld = tafel.zoekLegePlek(nrsSet1.stenen.size());
				for (int s = 0; s < nrsSet1.stenen.size(); s++)
					velden[eersteVeld.y][eersteVeld.x + s].setSteen(nrsSet1.stenen.get(s));
				    eersteVeld = tafel.zoekLegePlek(nrsSet2.stenen.size());
				for (int s = 0; s < nrsSet2.stenen.size(); s++)
					velden[eersteVeld.y][eersteVeld.x + s].setSteen(nrsSet2.stenen.get(s));
				
				//verwijder oude set
				for (int i = 0; i < sets.size(); i++)
					if (sets.get(i).id == nrsSet.id)
						sets.remove(i);

				//voeg nieuwe sets toe 
				sets.add(nrsSet1);
				sets.add(nrsSet2);
rk.checkConsistentie(4);					 
				rk.steenWeggelegd = true;
				return true;
			}
		}	
		


		ArrayList<Steen> vrijeStenen = new ArrayList<Steen>();  
		/* vrijeStenen bevat alle stenen op het veld die weggehaald kunnen worden, 
		   zonder dat de set waartoe de steen behoort ongeldig wordt */

		for (RSet set : sets) 
		{
			ArrayList<Steen> vrijeStenenSet = set.getVrijeStenen();
			for (Steen vrijeSteen : vrijeStenenSet)
				vrijeStenen.add(vrijeSteen);
		} 
			 
		//probeer 2 bord-stenen te combineren met 1 vrijeSteen 		
		//impl: probeer domweg alle mogelijke combinaties uit van {bord-steen,bord-steen,vrije-steen}...
		//...en check of die combi "toevallig" een geldige set is.

		Steen st1, st2;
		for (int b1 = 0; b1 < adb.stenen.size(); b1++)
		{
			st1 = adb.stenen.get(b1);
			for (int b2 = 0; b2 < b1; b2++)
			{
				st2 = adb.stenen.get(b2);
				for (Steen vrijeSt : vrijeStenen)
				{	
					//ArrayList<Steen> combi = sorteer(s1, s2, s3)    
					//sorteer werkt niet bij jokers, dan krijg je bvb "*13" ipv "1*3"
		
					ArrayList<ArrayList<Steen>> combis = new ArrayList<ArrayList<Steen>>();
					combis.add(steenList(st1, st2, vrijeSt));
					combis.add(steenList(st2, st1, vrijeSt));
					combis.add(steenList(st1, vrijeSt, st2));
					combis.add(steenList(st2, vrijeSt, st1));
					combis.add(steenList(vrijeSt, st1, st2));
					combis.add(steenList(vrijeSt, st2, st1));

					for (ArrayList<Steen> combi : combis)
					{
						RSet nweSet = null;
						NummersSet nrsSet = NummersSet.validateRijtje(combi);
						KleurenSet klrSet = KleurenSet.validateRijtje(combi);
						if (nrsSet == null && klrSet == null)
							continue; //geen valide rijtje
						if (nrsSet != null && klrSet != null)
							nweSet = new AmbiSet(nrsSet, klrSet);
						else
						{
							if (nrsSet != null)
								nweSet = nrsSet;
							if (klrSet != null)
								nweSet = klrSet;
						}
					
						RSet vrSet = rk.getSetBySteen(vrijeSt);
						int ind_vrijeSt = vrSet.getIndexOfSteen(vrijeSt);
						if (vrSet instanceof KleurenSet)
						{	
							//verwijder vrije steen van veld:
							//voorkom dat er een gat onstaat in de kleurenset op het veld, schuif de rest op
							int x =	vrijeSt.x;
							int y = vrijeSt.y;
							for (int i = ind_vrijeSt; i < vrSet.stenen.size() - 1; i++)
							{
								velden[y][x].setSteen(vrSet.stenen.get(i + 1));	
								x++;
							}	
							velden[y][x].setSteen(null);

							((KleurenSet)vrSet).removeSteen(vrijeSt);
						}
						if (vrSet instanceof NummersSet) 
						{
							NummersSet vrNrsSet = (NummersSet)vrSet;
							
							if (vrNrsSet.isAtUiteinde(vrijeSt))
								vrNrsSet.removeSteen(vrijeSt);
							else
							{	//steen wordt (straks) weggehaald MIDDEN uit de rij,
								//creeer 2 nieuwe sets ipv de oude

								NummersSet vrNrsSet1 = new NummersSet();
								vrNrsSet1.kleur = vrNrsSet.kleur;
								vrNrsSet1.eersteNummer = vrNrsSet.eersteNummer;
								vrNrsSet1.stenen = new ArrayList<Steen>();
								for (int i = 0; i < ind_vrijeSt; i++)
									vrNrsSet1.stenen.add(vrNrsSet.stenen.get(i));
				
								NummersSet vrNrsSet2 = new NummersSet();
								vrNrsSet2.kleur = vrNrsSet.kleur;
								vrNrsSet2.eersteNummer = vrNrsSet.eersteNummer + ind_vrijeSt + 1;
								vrNrsSet2.stenen = new ArrayList<Steen>();
								for (int i = ind_vrijeSt + 1; i < vrNrsSet.stenen.size(); i++)
									vrNrsSet2.stenen.add(vrNrsSet.stenen.get(i));											

								//verwijder vrNrsSet
								for (int i = 0; i < sets.size(); i++)
									if (sets.get(i).id == vrNrsSet.id)
										sets.remove(i);

								sets.add(vrNrsSet1);
								sets.add(vrNrsSet2);
							}
							
							//verwijder vrije steen van veld
							velden[vrijeSt.y][vrijeSt.x].setSteen(null);
						}
													
						//verwijder st1 en st2 van bordje
						for (int i = 0; i < adb.stenen.size(); i++)
							if (adb.stenen.get(i).id == st1.id)
								adb.stenen.remove(i);
						for (int i = 0; i < adb.stenen.size(); i++)
							if (adb.stenen.get(i).id == st2.id)
								adb.stenen.remove(i);
						velden[st1.y][st1.x].setSteen(null);
						velden[st2.y][st2.x].setSteen(null);
		

						//voeg nieuwe set(combi) toe aan veld
						Pos eersteVeld = tafel.zoekLegePlek(nweSet.stenen.size());
						for (int s = 0; s < nweSet.stenen.size(); s++)
{
							velden[eersteVeld.y][eersteVeld.x + s].setSteen(nweSet.stenen.get(s));

	//System.out.print(nweSet.stenen.get(s) + " ");
}						
//System.out.println("  " + vrijeSt + " " + (vrSet instanceof KleurenSet));
	
						sets.add(nweSet);
rk.checkConsistentie(5);
						rk.steenWeggelegd = true;
						return true;
					}
				}
			}
		}



		//probeer 1 bord-steen te combineren met 2 vrijeStenen

		Steen[] vrSt = new Steen[2];
		for (Steen bSt : adb.stenen)
			for (int v1 = 0; v1 < vrijeStenen.size(); v1++)
			{  	
				vrSt[0] = vrijeStenen.get(v1);
				RSet vrSet0 = rk.getSetBySteen(vrSt[0]);				
	
				for (int v2 = 0; v2 < vrijeStenen.size(); v2++)
				{	
					if (v2 == v1)
						continue;
					vrSt[1] = vrijeStenen.get(v2);			
					RSet vrSet1 = rk.getSetBySteen(vrSt[1]);				
	
					/*
					controleer eerst of de combinatie van beide vrije stenen wel mogelijk is;
					je kan vaak geen 2 vrije stenen uit DEZELFDE SET verwijderen;
					voor het gemak kan dat je enige criterium zijn: geen 2 vrije stenen uit dezelfde set.
					welke scenario's zijn er dat 2 vrije stenen uit dezelfde set WEL mogelijk (EN zinvol) is?
					- 1vd2 is een joker.   kan in theorie voorkomen. pech dan, joker-geval elders behandelen
					- 2 (opeenvolgende) cijfers (midden) in een (lange) NummersSet
						dit scenario wordt al gedekt(denk ik) bij "invoegen in nummersSet"
					*/
					if (vrSet1.id == vrSet0.id)
 						continue;

					ArrayList<ArrayList<Steen>> combis = new ArrayList<ArrayList<Steen>>();
					combis.add(steenList(bSt, vrSt[0], vrSt[1]));
					combis.add(steenList(vrSt[0], bSt, vrSt[1]));
					combis.add(steenList(vrSt[0], vrSt[1], bSt));
					
					for (ArrayList<Steen> combi : combis)
					{						
						RSet nweSet = null;
						NummersSet nrsSet = NummersSet.validateRijtje(combi);
						KleurenSet klrSet = KleurenSet.validateRijtje(combi);
						if (nrsSet == null && klrSet == null)
							continue; //geen valide rijtje
						if (nrsSet != null && klrSet != null)
							nweSet = new AmbiSet(nrsSet, klrSet);
						else
						{
							if (nrsSet != null)
								nweSet = nrsSet;
							if (klrSet != null)
								nweSet = klrSet;
						}
								
						for (int v = 0; v < 2; v++) // for allebei de vrije stenen: (verwijder ze)
						{
							Steen vrijeSt = vrSt[v];
							RSet vrSet = rk.getSetBySteen(vrijeSt);
							int ind_vrijeSt = vrSet.getIndexOfSteen(vrijeSt);
							if (vrSet instanceof KleurenSet)
							{	
								//verwijder vrije steen van veld:
								//voorkom dat er een gat onstaat in de kleurenset op het veld, schuif de rest op
								int x =	vrijeSt.x;
								int y = vrijeSt.y;
								for (int i = ind_vrijeSt; i < vrSet.stenen.size() - 1; i++)
								{
									velden[y][x].setSteen(vrSet.stenen.get(i + 1));	
									x++;
								}	
								velden[y][x].setSteen(null);
	
								((KleurenSet)vrSet).removeSteen(vrijeSt);
							}
							if (vrSet instanceof NummersSet) 
							{
								NummersSet vrNrsSet = (NummersSet)vrSet;
								
								if (vrNrsSet.isAtUiteinde(vrijeSt))
									vrNrsSet.removeSteen(vrijeSt);
								else
								{	//steen wordt (straks) weggehaald MIDDEN uit de rij,
									//creeer 2 nieuwe sets ipv de oude

									NummersSet vrNrsSet1 = new NummersSet();
									vrNrsSet1.kleur = vrNrsSet.kleur;
									vrNrsSet1.eersteNummer = vrNrsSet.eersteNummer;
									vrNrsSet1.stenen = new ArrayList<Steen>();
									for (int i = 0; i < ind_vrijeSt; i++)
										vrNrsSet1.stenen.add(vrNrsSet.stenen.get(i));
				
									NummersSet vrNrsSet2 = new NummersSet();
									vrNrsSet2.kleur = vrNrsSet.kleur;
									vrNrsSet2.eersteNummer = vrNrsSet.eersteNummer + ind_vrijeSt + 1;
									vrNrsSet2.stenen = new ArrayList<Steen>();
									for (int i = ind_vrijeSt + 1; i < vrNrsSet.stenen.size(); i++)
										vrNrsSet2.stenen.add(vrNrsSet.stenen.get(i));											

									//verwijder vrNrsSet
									for (int i = 0; i < sets.size(); i++)
										if (sets.get(i).id == vrNrsSet.id)
											sets.remove(i);
	
									sets.add(vrNrsSet1);
									sets.add(vrNrsSet2);
								}
								
								//verwijder vrije steen van veld
								velden[vrijeSt.y][vrijeSt.x].setSteen(null);
							}
						}
	
						//verwijder bord-steen van bordje
						for (int i = 0; i < adb.stenen.size(); i++)
							if (adb.stenen.get(i).id == bSt.id)
								adb.stenen.remove(i);
						velden[bSt.y][bSt.x].setSteen(null);
							

						//voeg nieuwe set(combi) toe aan veld
						Pos eersteVeld = tafel.zoekLegePlek(nweSet.stenen.size());
						for (int s = 0; s < nweSet.stenen.size(); s++)
{
							velden[eersteVeld.y][eersteVeld.x + s].setSteen(nweSet.stenen.get(s));

	//System.out.print(nweSet.stenen.get(s) + " ");
}						
//System.out.println("  b-v-v combi");
	
						sets.add(nweSet);
rk.checkConsistentie(6);
						rk.steenWeggelegd = true;
						return true;
					}	
				}
			}

			 
		return false;
	}
	

	


	void zoekInwisselbareJokers()
	{
		ArrayList<Steen> inwisselJokers = new ArrayList<Steen>();
		ArrayList<RSet> aanlSets = new ArrayList<RSet>();
		for (RSet set : sets)
		{
			ArrayList<ISteen> jvss = set.getJokerVervangendeStenen();
			for (ISteen jvs : jvss)
			{
				Steen jokerVervangendeSteen = zoekSteenOpBordje(jvs.kleur, jvs.nummer);
				if (jokerVervangendeSteen != null)
				{

					//zoek een geschikte set om de joker bij aan te leggen
					RSet aanlSet = null;
					for (RSet aSet : sets)
					{
						if (aanlSets.size() == 1 && aSet.id == aanlSets.get(0).id)
							continue;
													
						if (aSet instanceof NummersSet) 
						{
							NummersSet aNrsSet = (NummersSet)aSet;
							int laatsteNr = aNrsSet.eersteNummer + aNrsSet.stenen.size() - 1; 
							if (laatsteNr < 13)
							{
								aanlSet = aSet;
								break;
							}
						}
					}
					if (aanlSet == null) //geen geschikte aanleg-set gevonden, dus wissel ook geen joker in 
						break;
						
					aanlSets.add(aanlSet);

					int joker_ind = -1;
					for (int i = 0; i < set.stenen.size(); i++)
						if (set.stenen.get(i).joker)	
						{ 
							joker_ind = i;
							break;
						}
					Steen inwisselJoker = set.stenen.get(joker_ind);

					//verwijder jvs van bordje
					for (int i = 0; i < adb.stenen.size(); i++)
						if (adb.stenen.get(i).id == jokerVervangendeSteen.id)
							adb.stenen.remove(i);
					velden[jokerVervangendeSteen.y][jokerVervangendeSteen.x].setSteen(null);
						
					set.stenen.set(joker_ind, jokerVervangendeSteen);
					
					velden[inwisselJoker.y][inwisselJoker.x].setSteen(jokerVervangendeSteen); 
					
					inwisselJokers.add(inwisselJoker);	

					break;
				}
			}				
		}
	


		//dump de gevonden inwissel-jokers op de tafel, zodat het vrije stenen worden die later kunnen worden gebruikt
		
		for (int jkr = 0; jkr < inwisselJokers.size(); jkr++)
		{
			Steen inwJoker = inwisselJokers.get(jkr);
			RSet aanlSet = aanlSets.get(jkr);

			Steen steen = inwJoker;
			RSet nrsSet = aanlSet;
			
			//x en y van de aan te leggen steen
			int x = -1;
			int y = -1;
			
			if (pastToevoegen(nrsSet, false)) 
			{
				x = nrsSet.stenen.get(0).x + nrsSet.stenen.size();
				y = nrsSet.stenen.get(0).y;
			}
			else
			{
				//verplaats huidige set naar elders
				Pos eersteVeld = tafel.zoekLegePlek(nrsSet.stenen.size() + 1);
				for (int s = 0; s < nrsSet.stenen.size(); s++)
				{
					Steen setSteen = nrsSet.stenen.get(s);
					velden[setSteen.y][setSteen.x].setSteen(null);
					velden[eersteVeld.y][eersteVeld.x + s].setSteen(setSteen);			
				}
	
				x = eersteVeld.x + nrsSet.stenen.size(); 
				y = eersteVeld.y;
			}
		
			velden[y][x].setSteen(steen);			
					
			nrsSet.addSteen(steen, false);
//System.out.println("joker ingewisseld.");
		}

rk.checkConsistentie(7);
		
	}
	




	ArrayList<Steen> steenList(Steen st1, Steen st2, Steen st3)
	{
		ArrayList<Steen> stenen = new ArrayList<Steen>();
		stenen.add(st1);
		stenen.add(st2);
		stenen.add(st3);
		return stenen;
	}
		

	
	private boolean pastToevoegen(RSet set, boolean vooraan)
	{
		if (vooraan) 
		{
			if (set.stenen.get(0).x < 2)
				return false;
			return (velden[set.stenen.get(0).y][set.stenen.get(0).x - 1].steen == null &&
				velden[set.stenen.get(0).y][set.stenen.get(0).x - 2].steen == null);
		}
		else
		{
			int laatsteIndex = set.stenen.get(0).x + set.stenen.size();
			if (laatsteIndex > tafel.aantKol - 2)
				return false;
			return (velden[set.stenen.get(0).y][set.stenen.get(0).x + set.stenen.size()].steen == null &&
				velden[set.stenen.get(0).y][set.stenen.get(0).x + set.stenen.size() + 1].steen == null);
		}
	}

}