import java.util.ArrayList;



class KleurenSet extends RSet
{
	int nummer;


	static KleurenSet validateRijtje(ArrayList<Steen> rijtje)
	{
		KleurenSet klrSet = new KleurenSet();
		if (klrSet.validate(rijtje))
			return klrSet;
		else 	
			return null;
	}


	
	private boolean validate(ArrayList<Steen> rijtje) 
	{
		stenen = rijtje;
		
		if (stenen.size() < 3 || stenen.size() > 4)
			return false;
		
		if (stenen.get(0).joker && stenen.get(1).joker)
			nummer = stenen.get(2).nummer;
		else
		{ 
			if (stenen.get(0).joker)
				nummer = stenen.get(1).nummer;
			else
				nummer = stenen.get(0).nummer;
		}
		
		for (int s = 0; s < stenen.size(); s++)
		{
			Steen steen = stenen.get(s);
			if (steen.joker)
				continue;
			if (steen.nummer != nummer)
				return false;
			for (int t = 0; t < s; t++)
			{
				if (stenen.get(t).joker)
					continue;
				if (steen.kleur == stenen.get(t).kleur) //kleur van de steen is hetzelfde als die van een eerdere steen
					return false;
			}
		}
		return true;
	}
	
	

	ISteen getAanlegbareSteen()
	{
		if (stenen.size() == 4)
			return null;
		boolean[] aanwezigeKleuren = new boolean[4];
		for (Steen steen : stenen)
		{
			if (steen.joker)
				return null; //we leggen geen stenen aan bij kleurenSets met een joker erin
			aanwezigeKleuren[steen.kleur] = true;
		}
		for (int kl = 0; kl < 4; kl++)
			if (!aanwezigeKleuren[kl])
				return ISteen.steen[kl][nummer]; 

		return null;//zou nooit bereikt moeten worden	
	}



	ArrayList<Steen> getVrijeStenen()
	{
		if (stenen.size() == 4)
			return stenen;
		else
			return new ArrayList<Steen>();
	}	
		
		
	
	void removeSteen(Steen steen)
	{
		int ind = getIndexOfSteen(steen);
		stenen.remove(ind);
	}
	
	

	ArrayList<ISteen> getJokerVervangendeStenen() 
	{
		for (int i = 0; i < stenen.size(); i++)
			if (stenen.get(i).joker)
			{
				ArrayList<ISteen> jvs = new ArrayList<ISteen>();
				boolean[] aanwezigeKleuren = new boolean[4];
				for (Steen steen : stenen)
					if (!steen.joker)
						aanwezigeKleuren[steen.kleur] = true;
				for (int kl = 0; kl < 4; kl++)
					if (!aanwezigeKleuren[kl])
						jvs.add(ISteen.steen[kl][nummer]); 
				return jvs;
			}
		
		return new ArrayList<ISteen>();
	}

}