import java.util.ArrayList;



class NummersSet extends RSet
{
	int eersteNummer;
	int kleur;



	static NummersSet validateRijtje(ArrayList<Steen> rijtje)
	{
		NummersSet nrsSet = new NummersSet();
		if (nrsSet.validate(rijtje))
			return nrsSet;
		else 	
			return null;
	}


	
	private boolean validate(ArrayList<Steen> rijtje) 
	{
		stenen = rijtje;
		
		if (stenen.size() < 3)
			return false;
		
		if (stenen.get(0).joker && stenen.get(1).joker)
		{
			eersteNummer = stenen.get(2).nummer - 2;
			kleur = stenen.get(2).kleur;
		}
		else
		{ 
			if (stenen.get(0).joker)
			{
				eersteNummer = stenen.get(1).nummer - 1;
				kleur = stenen.get(1).kleur;
			}
			else
			{
				eersteNummer = stenen.get(0).nummer;
				kleur = stenen.get(0).kleur;
			}
		}
		if (eersteNummer < 1)
			return false;
		int laatsteNummer = eersteNummer + stenen.size() - 1;
		if (laatsteNummer > 13)
			return false;

		for (int s = 0; s < stenen.size(); s++)
		{
			Steen steen = stenen.get(s);
			if (steen.joker)
				continue;
			if (steen.kleur != kleur)
				return false;
			if (steen.nummer != eersteNummer + s)
				return false;		
		}

		return true;
	}
	


	ISteen getAanlegbareSteenVooraan()
	{
		if (eersteNummer == 1)
			return null;
		return ISteen.steen[kleur][eersteNummer - 1];
		
	}



	ISteen getAanlegbareSteenAchteraan()
	{
		int laatsteNummer = eersteNummer + stenen.size() - 1;
		if (laatsteNummer == 13)
			return null;
		return ISteen.steen[kleur][laatsteNummer + 1];
	}



	void addSteen(Steen steen, boolean vooraan)
	{
		super.addSteen(steen, vooraan);
		if (vooraan)
			eersteNummer--;
	}



	ArrayList<Steen> getVrijeStenen()
	{
		ArrayList<Steen> vrijeStenen = new ArrayList<Steen>();
		if (stenen.size() > 3)
		{
			vrijeStenen.add(stenen.get(0));
			vrijeStenen.add(stenen.get(stenen.size() - 1));
 		}
		for (int i = 3; i < stenen.size() - 3; i++)
			vrijeStenen.add(stenen.get(i));
		return vrijeStenen;
	}	


	
	void removeSteen(Steen steen)
	{
		int ind = getIndexOfSteen(steen);
		stenen.remove(ind);
		if (ind == 0)
			eersteNummer++;
	}



	boolean isAtUiteinde(Steen steen) 
	{
		int ind = getIndexOfSteen(steen);
		return (ind == 0 || ind == stenen.size() - 1);
	}



	ArrayList<ISteen> getJokerVervangendeStenen() 
	{
		for (int i = 0; i < stenen.size(); i++)
			if (stenen.get(i).joker)
			{
				ArrayList<ISteen> jvs = new ArrayList<ISteen>();
				int jvs_nr = eersteNummer + i;
				jvs.add(ISteen.steen[kleur][jvs_nr]); 
				return jvs;
			}
		
		return new ArrayList<ISteen>();
	}

}