import java.util.ArrayList;
import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Alert.AlertType;
import javafx.scene.control.Button;
import javafx.scene.control.TextInputDialog;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.stage.Stage;



public class Rummikub extends Application 
{
	final static int VELD_BREEDTE = 25;
	final static int VELD_HOOGTE = 50;
	final static int STEEN_BREEDTE = VELD_BREEDTE;
	final static int STEEN_HOOGTE = 40;

	Speler[] spelers;
	int adb_ind;
	Speler adb;
	ArrayList<Steen> pot;
	boolean steenWeggelegd;
	ArrayList<RSet> sets;

	ArrayList<Steen> bu_bordStenen;	
	Steen[][] bu_veldStenen;

	Pos fromVeld;
	Pos selVeld;
	Rectangle selVeldRect;	

	AnchorPane rootPane;
	Tafel tafel;

	AnchorPane rightPane;
	Text txtAdb;
	Button btnKlaar;
	Button btnRestore;
	Button btnSorteerBordje;



	@Override
	public void start(Stage stage) throws Exception 
	{
		rootPane = new AnchorPane();
		
		Scene scene = new Scene(rootPane, 1100, 700, Color.LIGHTGREY);

		stage.setTitle("Rummikub");
		stage.setScene(scene);
		stage.show();

		tafel = new Tafel(this);
		AnchorPane.setLeftAnchor(tafel, 20.0);
		AnchorPane.setTopAnchor(tafel, 20.0);
		rootPane.getChildren().add(tafel);

		ISteen.init();
		pot = new ArrayList<Steen>();

		for (int i = 0; i < 2; i++)
		{
			for (int kl = 0; kl < 4; kl++)
				for (int nr = 1; nr <= 13; nr++)
					pot.add(new Steen(kl, nr, false));
			pot.add(new Steen(0, 0, true)); //joker
		}

		
		int aantHumanSpelers = 0;
		String question = "Aantal menselijke spelers:";
		while (true)
		{
			String strAantHumanSpelers = inputDialog(question);
			if (strAantHumanSpelers.equals(""))
				continue;
			try { aantHumanSpelers = Integer.parseInt(strAantHumanSpelers); } catch (NumberFormatException nfExc) 					{ continue; } 
			if (aantHumanSpelers < 1 || aantHumanSpelers > 4)
				continue;
			break;
		}

		int aantCompSpelers = 0;
		question = "Aantal computer-spelers:";
		while (true)
		{
			String strAantCompSpelers = inputDialog(question);
			if (strAantCompSpelers.equals(""))
				continue;
			try { aantCompSpelers = Integer.parseInt(strAantCompSpelers); } catch (NumberFormatException nfExc) 					{ continue; } 
			if (aantCompSpelers < 0 || aantHumanSpelers + aantCompSpelers > 4)
				continue;
			break;
		}

		spelers = new Speler[aantHumanSpelers + aantCompSpelers];
		for (int s = 0; s < aantHumanSpelers; s++)
			spelers[s] = new HumanSpeler(s, "Speler " + (char)('A' + s));	 
		for (int s = aantHumanSpelers; s < aantHumanSpelers + aantCompSpelers; s++)
			spelers[s] = new CompSpeler(this, s, "Speler " + (char)('A' + s));

		for (int s = 0; s < spelers.length; s++)
		{
			clearBordje();
			for (int i = 0; i < 14; i++)
			{
				Steen steen = trekEenSteen();
				spelers[s].stenen.add(steen);
				tafel.addSteenToBordje(steen);
			}
		}

//		tafel.velden[0][0].setSteen(new Steen(0, 5, false));
//		tafel.velden[1][0].setSteen(new Steen(1, 10, false));

		tafel.addEventFilter(MouseEvent.MOUSE_PRESSED, new EventHandler<MouseEvent>() {
			public void handle(MouseEvent mouseEvent) 
			{
				double x = mouseEvent.getX();
				double y = mouseEvent.getY();
				//System.out.println("mouse pressed at " + x + "," + y);

				int kol = (int) (x / VELD_BREEDTE);
				int rij = (int) (y / VELD_HOOGTE);
				//System.out.println("mouse pressed at veld " + rij + "," + kol);

				if (kol < 0 || kol >= tafel.aantKol || rij < 0 || rij >= tafel.aantRij)
					fromVeld = null;  //NB komt voor als je op het randje klikt
				else 
					fromVeld = new Pos(kol, rij);
			}
		});

		tafel.addEventFilter(MouseEvent.MOUSE_RELEASED, new EventHandler<MouseEvent>() {
			public void handle(MouseEvent mouseEvent) 
			{
				mouseReleased(mouseEvent);				
			}
		});

		rightPane = new AnchorPane();
		AnchorPane.setLeftAnchor(rightPane, 40.0 + VELD_BREEDTE * tafel.aantKol);
		AnchorPane.setTopAnchor(rightPane, 20.0);	
		rootPane.getChildren().add(rightPane);

		txtAdb = new Text("");
		AnchorPane.setLeftAnchor(txtAdb, 0.0);
		AnchorPane.setTopAnchor(txtAdb, 0.0); 
		rightPane.getChildren().add(txtAdb);

		btnKlaar = new Button("Klaar");
		AnchorPane.setLeftAnchor(btnKlaar, 0.0);
		AnchorPane.setTopAnchor(btnKlaar, VELD_HOOGTE * tafel.aantRij - 25.0);
		rightPane.getChildren().add(btnKlaar);
		
		btnKlaar.setOnAction(new EventHandler<ActionEvent>() {
			@Override public void handle(ActionEvent e) 
			{
				sets = controleerTafel();
				if (sets == null)
					alert("Ongeldige tafel");
				else	
					eindeBeurt();
			
			}
		});

		btnRestore = new Button("Maak beurt ongedaan");
		AnchorPane.setLeftAnchor(btnRestore, 100.0);
		AnchorPane.setTopAnchor(btnRestore, VELD_HOOGTE * tafel.aantRij - 25.0);
		rightPane.getChildren().add(btnRestore);
		
		btnRestore.setOnAction(new EventHandler<ActionEvent>() {
			@Override public void handle(ActionEvent e)
			{
				maakBeurtOngedaan();
			}
		}); 

		selVeldRect = new Rectangle(STEEN_BREEDTE, STEEN_HOOGTE);
		selVeldRect.setStroke(Color.RED);
		selVeldRect.setFill(null);
		selVeldRect.setVisible(false);		
		tafel.getChildren().add(selVeldRect);

		scene.setOnKeyPressed(new EventHandler<KeyEvent>() {
            		@Override
            		public void handle(KeyEvent event) 
			{
                		verwerkKeyEvent(event.getCode());
                    	}
                });

		btnSorteerBordje = new Button("Sorteer bordje");
		AnchorPane.setLeftAnchor(btnSorteerBordje, 0.0);
		AnchorPane.setTopAnchor(btnSorteerBordje, VELD_HOOGTE * tafel.aantRij - 100.0);
		rightPane.getChildren().add(btnSorteerBordje);
		
		btnSorteerBordje.setOnAction(new EventHandler<ActionEvent>() {
			@Override public void handle(ActionEvent e)
			{
				sorteerBordje();
			}
		}); 
		
		setAdb(0);
	}


			
	void mouseReleased(MouseEvent mouseEvent)
	{
		if (fromVeld == null)
			return;
		Steen steen = tafel.velden[fromVeld.y][fromVeld.x].steen;
		if (steen == null)
			return;
		double x = mouseEvent.getX();
		double y = mouseEvent.getY();
		int kol = (int) (x / VELD_BREEDTE);
		int rij = (int) (y / VELD_HOOGTE);

		if (kol < 0 || kol >= tafel.aantKol || rij < 0 || rij >= tafel.aantRij)
			return;  //gebeurt als er naar buiten de tafel(het kader) wordt gesleept	
					
		if (kol == fromVeld.x && rij == fromVeld.y)  //mouse-press en -release op hetzelfde veld
		{	
			selectVeld(rij, kol);	
			return;
		}

		if (tafel.velden[rij][kol].steen != null) //er bevindt zich al een steen op dit veld 
			return; 
		
				
		//mag geen steen (terug)verplaatsen van de tafel naar het bordje
		if (fromVeld.y < tafel.aantRij - 2 && rij >= tafel.aantRij - 2)
			return;  				
			
		//verwijder de steen uit speler.stenen bij een verplaatsing van bordje naar tafel
		if (fromVeld.y >= tafel.aantRij - 2 && rij < tafel.aantRij - 2)
		{
			steenWeggelegd = true;		
			for (int i = 0; i < adb.stenen.size(); i++)
				if (adb.stenen.get(i).id == steen.id)
					adb.stenen.remove(i);
		}

		tafel.velden[fromVeld.y][fromVeld.x].setSteen(null);
		//steen.x = kol;
		//steen.y = rij;
		tafel.velden[rij][kol].setSteen(steen);
			
		selectVeld(rij, kol);
	}



	void selectVeld(int rij, int kol)
	{	
		selVeldRect.setVisible(true);
		AnchorPane.setLeftAnchor(selVeldRect, 0.0 + kol * VELD_BREEDTE);
		AnchorPane.setTopAnchor(selVeldRect, 0.0 + rij * VELD_HOOGTE); 
		
		selVeld = new Pos(kol, rij);
	}

			

	void verwerkKeyEvent(KeyCode key)
	{	
		if (key == KeyCode.NUMPAD6)
			tafel.moveRight();
		if (key == KeyCode.NUMPAD4)
			tafel.moveLeft();		
		if (key == KeyCode.NUMPAD8)
			tafel.moveUp();
		if (key == KeyCode.NUMPAD2)
			tafel.moveDown();
	}



	void setAdb(int adb_ind)
	{
		this.adb_ind = adb_ind;
		adb = spelers[adb_ind];

		if (adb.uit)
		{
			//prog loopt hier(denk ik) over als iedereen uit is. 
			//EDIT half gefixt. alleen nog als er alleen (nog) maar met computerspelers wordt gespeeld
			setAdb((adb_ind + 1) % spelers.length);
			return;
		}

		txtAdb.setText("Aan de beurt:   " + adb.naam);

		clearBordje();

		//zet de stenen van adb op het bordje
		for (Steen steen : adb.stenen)
			tafel.velden[steen.y][steen.x].setSteen(steen);
		
		steenWeggelegd = false;
		
		if (adb instanceof HumanSpeler)
			makeBackup();
			
		if (adb instanceof CompSpeler)
		{	
			new ComputerBeurt(this);
			//((CompSpeler)adb).speelBeurt();
			alert("einde beurt " + adb.naam);
			eindeBeurt();
		}		
	}



	void eindeBeurt()
	{
		if (adb.stenen.size() == 0)
		{
			adb.uit = true;
			alert(adb.naam + " is uit!");
			boolean iedereenIsUit = true;
			for (int i = 0; i < spelers.length; i++)
				if (!spelers[i].uit)
					iedereenIsUit = false;
			if (iedereenIsUit)
			{
				btnKlaar.setDisable(true);
				btnRestore.setDisable(true);
				btnSorteerBordje.setDisable(true);
				return;
			}
		}
		else
			if (!steenWeggelegd)
			{
				Steen steen = trekEenSteen();
				if (steen != null)
				{
					adb.stenen.add(steen);
					tafel.addSteenToBordje(steen);
				}
			}
					
		setAdb((adb_ind + 1) % spelers.length);
	}



	ArrayList<RSet> controleerTafel()
	{
		ArrayList<ArrayList<Steen>> rijtjes = tafel.getRijtjes();

/* print for testing
		for (ArrayList<Steen> rijtje : rijtjes)
		{
			for (Steen steen : rijtje)
				System.out.print(steen.nummer + " ");
			System.out.print("   ");
		}
		System.out.println();
*/	

		ArrayList<RSet> newSets = new ArrayList<RSet>();
		for (ArrayList<Steen> rijtje : rijtjes)
		{
			NummersSet nrsSet = NummersSet.validateRijtje(rijtje); 
			KleurenSet klrSet = KleurenSet.validateRijtje(rijtje);
			if (nrsSet == null) //rijtje is geen valide nummersSet
			{
				if (klrSet == null) //rijtje is ook geen valide nummersSet
					return null; //rijtje, en dus de hele tafel, is niet valide
				else
					newSets.add(klrSet);
			}
			else
			{
				if (klrSet != null)
					newSets.add(new AmbiSet(nrsSet, klrSet));
				else
					newSets.add(nrsSet);
			}	
		}
		return newSets;
	}



	void sorteerBordje()
	{

		clearBordje();

		ArrayList<Steen> stenen = new ArrayList<Steen>();
		for (Steen steen : adb.stenen)
			stenen.add(steen);		
		
		//1e joker
		for (int s = 0; s < stenen.size(); s++)
		{	
			Steen steen = stenen.get(s);
			if (steen.joker) 
			{
				steen.x = tafel.aantKol - 1;
				steen.y = tafel.aantRij - 2;
				stenen.remove(s);
				tafel.velden[steen.y][steen.x].setSteen(steen);
				break;
			}			
		}

		//2e joker
		for (int s = 0; s < stenen.size(); s++)
		{	
			Steen steen = stenen.get(s);
			if (steen.joker) 
			{
				steen.x = tafel.aantKol - 2;
				steen.y = tafel.aantRij - 2;
				stenen.remove(s);
				tafel.velden[steen.y][steen.x].setSteen(steen);
				break;
			}			
		}

		for (int kleur = 0; kleur < 4; kleur++)
		{
			int ind = 0;
			while (true)
			{
				int min_ind = -1;
				int min_nummer = 999;
				for (int s = 0; s < stenen.size(); s++)
				{	
					Steen steen = stenen.get(s);   //checken op joker hoeft niet, want die zijn er al uitgehaald
					if (steen.kleur == kleur && steen.nummer < min_nummer)
					{
						min_ind = s;
						min_nummer = steen.nummer;
					}
				}
				if (min_ind == -1) //geen steen in de specifieke kleur (meer) gevonden
					break;
				else 
				{
					Steen min_steen = stenen.remove(min_ind);
					min_steen.x = ind;
					if (kleur == 1 || kleur == 3)
						min_steen.x += 13;
					if (kleur == 0 || kleur == 1)
						min_steen.y = tafel.aantRij - 2;
					else
						min_steen.y = tafel.aantRij - 1; 
					tafel.velden[min_steen.y][min_steen.x].setSteen(min_steen);

					ind++;
					if (ind == 13)	//mochten er meer dan 13 stenen in deze kleur zijn, 
						break;	//   dan komen die op de overloop terecht  
				}  
			}	
		}	

		
		//tenslotte: overloop. niet teveel op letten, komt normaal niet voor bij zo'n groot bordje (met 13... per kl) 
	
		int x = tafel.aantKol - 3;
		int y = tafel.aantRij - 1;
		for (Steen steen : stenen)
		{
			while (tafel.velden[y][x].steen != null)
			{
				x--;
				if (x == -1)
				{
					x = tafel.aantKol - 1;
					y--;    //negeer het overlopen van de overloop, zoals je het evt volraken van het bordje negeert
				}	
			}

			tafel.velden[y][x].setSteen(steen);
		}
	}



	void clearBordje()
	{
		for (int r = tafel.aantRij - 2; r < tafel.aantRij; r++)
			for (int k = 0; k < tafel.aantKol; k++)
				tafel.velden[r][k].setSteen(null);		
	}



	Steen trekEenSteen()
	{
		if (pot.size() == 0)
			return null;
		int ind = (int) (Math.random() * pot.size());
		return pot.remove(ind);
	}


	
	RSet getSetBySteen(Steen targetSteen)
	{
		for (RSet set : sets)
			for (Steen steen : set.stenen)
				if (steen.id == targetSteen.id)
					return set;
		return null;
	}
	


	void makeBackup()
	{
		bu_bordStenen = new ArrayList<Steen>();
		for (Steen steen : adb.stenen)
			bu_bordStenen.add(new Steen(steen));

		bu_veldStenen = new Steen[tafel.aantRij - 2][tafel.aantKol];
		for (int r = 0; r < tafel.aantRij - 2; r++)
			for (int k = 0; k < tafel.aantKol; k++)
				if (tafel.velden[r][k].steen != null)
					bu_veldStenen[r][k] = new Steen(tafel.velden[r][k].steen);				
		
		/*krijg je geen problemen met (niet savebare) references naar Steen
		  bvb vanuit sets, die verwijzingen daar naar Steen-objecten gaan bij het restoren verloren

		  NB ............ hoe zit het al met verwijzingen vanuit het bordje (speler.stenen)
		  die koppeling is nu weg.        (alleen via id indirect nog te doen) 
		  welke koppeling.   we gokken er gwoon op dat het nog werkt
		*/
	}



	//restore backup
	void maakBeurtOngedaan()
	{
		adb.stenen = bu_bordStenen;

		for (int r = 0; r < tafel.aantRij - 2; r++)
			for (int k = 0; k < tafel.aantKol; k++)
				tafel.velden[r][k].setSteen(bu_veldStenen[r][k]);
					
		setAdb(adb_ind);
	}



	void checkConsistentie(int loc)
	{
		int aantStenenOpTafel = 0;
		for (int r = 0; r < tafel.aantRij - 2; r++)
			for (int k = 0; k < tafel.aantKol; k++)
				if (tafel.velden[r][k].steen != null)
					aantStenenOpTafel++;

		int aantStenenOpBordjes = 0;
		for (Speler speler : spelers)
			 aantStenenOpBordjes += speler.stenen.size();

		int aantMissendeStenen = 106 - pot.size() - aantStenenOpBordjes - aantStenenOpTafel;
		
		if (aantMissendeStenen != 0)
			System.out.println("Consistency check failed at " + loc + ". " + aantMissendeStenen + " stenen ontbreken.");
	}



	String inputDialog(String message) 	
	{
		TextInputDialog dialog = new TextInputDialog("");
		dialog.setContentText(message);
 		dialog.showAndWait();
		return dialog.getEditor().getText(); 
	}



	void alert(String message)
	{
		(new Alert(AlertType.INFORMATION, message)).showAndWait();
	}

}