import java.util.ArrayList;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;



class Tafel extends AnchorPane
{
	Rummikub rummikub;
	int aantRij = 12;
	int aantKol = 30; 
	Veld[][] velden;

	

	Tafel(Rummikub rummikub) 
	{	
		this.rummikub = rummikub;

		Rectangle bordjeRect = new Rectangle(aantKol * Rummikub.VELD_BREEDTE, 2 * Rummikub.VELD_HOOGTE);
		AnchorPane.setLeftAnchor(bordjeRect, 0.0);
		AnchorPane.setTopAnchor(bordjeRect, 0.0 + (aantRij - 2) * Rummikub.VELD_HOOGTE);
		bordjeRect.setFill(Color.BURLYWOOD);
		super.getChildren().add(bordjeRect);
		
		Rectangle tafelRect = new Rectangle(aantKol * Rummikub.VELD_BREEDTE, aantRij * Rummikub.VELD_HOOGTE);
		tafelRect.setStroke(Color.BLACK);
		tafelRect.setFill(null);
		super.getChildren().add(tafelRect);

		velden = new Veld[aantRij][aantKol];
		for (int r = 0; r < aantRij; r++)
			for (int k = 0; k < aantKol; k++)
			{
				Veld veld = new Veld(r, k);
				velden[r][k] = veld;
				AnchorPane.setLeftAnchor(veld, 0.0 + k * Rummikub.VELD_BREEDTE);
				AnchorPane.setTopAnchor(veld, 0.0 + r * Rummikub.VELD_HOOGTE);
				super.getChildren().add(veld);				
			} 
	}



	//bordje bestaat uit 2 rijen: de onderste 2 tafel-rijen
	void addSteenToBordje(Steen steen)
	{
		//zet de steen op de laatste plaats neer (tenzij daar al een steen staat, dan daarvoor)
		int kol = aantKol - 1;
		int rij = aantRij - 1;
		while (velden[rij][kol].steen != null)
		{
			if (kol == 0)  //gebeurt alleen als de onderste rij vol is
			{
				rij--; //negeer het geval dat ook de bovenste rij vol is
				kol = aantKol - 1;
			}
			else				
				kol--;
		}
		
		steen.x = kol;
		steen.y = rij;	
		velden[rij][kol].setSteen(steen);  	
	}	



	ArrayList<ArrayList<Steen>> getRijtjes()
	{	
		ArrayList<ArrayList<Steen>> rijtjes = new ArrayList<ArrayList<Steen>>();
		
		ArrayList<Steen> huidigRijtje;
		
		for (int r = 0; r < aantRij - 2; r++)
		{	
			huidigRijtje = null;
			for (int k = 0; k < aantKol; k++)
			{
				if (velden[r][k].steen == null)
				{
					if (huidigRijtje != null)
					{
						rijtjes.add(huidigRijtje);
						huidigRijtje = null;
					}	
				}
				else
				{
					if (huidigRijtje == null)
						huidigRijtje = new ArrayList<Steen>();
					huidigRijtje.add(velden[r][k].steen);
				}
			}
			if (huidigRijtje != null)
				rijtjes.add(huidigRijtje);
		}	

		return rijtjes;
	}








	
	void moveRight()
	{
		Pos selVeld = rummikub.selVeld;
		if (selVeld == null)
			return;
		if (velden[selVeld.y][selVeld.x].steen == null)
			return;
		int rij = selVeld.y;
		int kol = selVeld.x;

		int lastKol = kol;   //lastKol is van de laatste steen die verschoven moet worden
		while (true)
		{
			if (lastKol + 2 >= aantKol) 	//dan is er geen ruimte meer achter het te verschuiven zootje
				return;
							
			if (velden[rij][lastKol + 1].steen == null && velden[rij][lastKol + 2].steen == null)
				break;			//dan zijn de eerste 2 volgende velden vrij
				
			lastKol++; 
		}
		
		//start moving	
		for (int k = lastKol + 1; k > kol; k--)
			velden[rij][k].setSteen(velden[rij][k - 1].steen);
		velden[rij][kol].setSteen(null); 
			
		rummikub.selectVeld(rij, kol + 1);  
		
	}



	void moveLeft()
	{
		Pos selVeld = rummikub.selVeld;
		if (selVeld == null)
			return;
		if (velden[selVeld.y][selVeld.x].steen == null)
			return;
		int rij = selVeld.y;
		int kol = selVeld.x;

		int firstKol = kol;   
		while (true)
		{
			if (firstKol < 2) 
				return;

			if (velden[rij][firstKol - 1].steen == null && velden[rij][firstKol - 2].steen == null)
				break;			
			
			firstKol--;
		}

		for (int k = firstKol - 1; k < kol; k++)
			velden[rij][k].setSteen(velden[rij][k + 1].steen);
		velden[rij][kol].setSteen(null); 
			
		rummikub.selectVeld(rij, kol - 1);  
		
	}


		
	void moveUp()
	{
		Pos selVeld = rummikub.selVeld;
		if (selVeld == null)
			return;
		if (velden[selVeld.y][selVeld.x].steen == null)
			return;
		int rij = selVeld.y;
		int kol = selVeld.x;
		if (rij >= aantRij - 2)  //bordje
			return;	

		//bepaal welke stenen verplaatst moeten worden: alle stenen direct links en direct rechts van de geselecteerde steen
		int firstKol = kol;
		while (firstKol > 0 && velden[rij][firstKol - 1].steen != null)
			firstKol--; 
		int lastKol = kol;
		while (lastKol < aantKol - 1 && velden[rij][lastKol + 1].steen != null)
			lastKol++;

		//bepaal naar welke rij het rijtje stenen veplaatst kan worden
		if (rij == 0) //de stenen staan op de bovenste rij
			return;
		int targetRij = rij - 1;
		while (true)
		{
			boolean kanVerplaatsen = true;  //kan het rijtje naar deze targetRij verplaatst worden?

			//het rijtje mag geen stenen direct naast zich krijgen
			if (firstKol > 0 && velden[targetRij][firstKol - 1].steen != null)
				 kanVerplaatsen = false;				
			if (lastKol < aantKol - 1 && velden[targetRij][lastKol + 1].steen != null)
				 kanVerplaatsen = false;
				
			for (int k = firstKol; k <= lastKol; k++)
				if (velden[targetRij][k].steen != null)
					{ kanVerplaatsen = false; break; }

			if (kanVerplaatsen)
				break;
			else
			{
				targetRij--;
				if (targetRij == -1)  //alle rijen gecheckt, geen enkele heeft ruimte in de gewenste kolommen
					return;
			}
		}

		//start moving
		for (int k = firstKol; k <= lastKol; k++)
		{
			velden[targetRij][k].setSteen(velden[rij][k].steen);
			velden[rij][k].setSteen(null); 
		}	
		
		rummikub.selectVeld(targetRij, kol);
	}



	void moveDown()
	{
		Pos selVeld = rummikub.selVeld;
		if (selVeld == null)
			return;
		if (velden[selVeld.y][selVeld.x].steen == null)
			return;
		int rij = selVeld.y;
		int kol = selVeld.x;
		if (rij >= aantRij - 2)  //bordje
			return;	

		int firstKol = kol;
		while (firstKol > 0 && velden[rij][firstKol - 1].steen != null)
			firstKol--; 
		int lastKol = kol;
		while (lastKol < aantKol - 1 && velden[rij][lastKol + 1].steen != null)
			lastKol++;

		if (rij == aantRij - 3)
			return;
		int targetRij = rij + 1;
		while (true)
		{
			boolean kanVerplaatsen = true;

			if (firstKol > 0 && velden[targetRij][firstKol - 1].steen != null)
				 kanVerplaatsen = false;				
			if (lastKol < aantKol - 1 && velden[targetRij][lastKol + 1].steen != null)
				 kanVerplaatsen = false;
				
			for (int k = firstKol; k <= lastKol; k++)
				if (velden[targetRij][k].steen != null)
					{ kanVerplaatsen = false; break; }

			if (kanVerplaatsen)
				break;
			else
			{
				targetRij++;
				if (targetRij == aantRij - 2)  //alle rijen gecheckt, geen enkele heeft ruimte in de gewenste kolommen
					return;
			}
		}
		
		for (int k = firstKol; k <= lastKol; k++)
		{
			velden[targetRij][k].setSteen(velden[rij][k].steen);
			velden[rij][k].setSteen(null); 
		}	
		
		rummikub.selectVeld(targetRij, kol);
	}
	


	Pos zoekLegePlek(int aantStenen)
	{
		int x = 1;
		int y = 0; 
		while (!isBereikLeeg(y, x - 1, x + aantStenen))
		{ 		
			x++;
			if (x == aantKol - 1)
			{
				x = 1;
				y++;
			}
		}
		return new Pos(x, y);
	}



	boolean isBereikLeeg(int y, int x_first, int x_last) 
	{
		if (x_last >= aantKol)
			return false;
	
		for (int x = x_first; x <= x_last; x++)
			if (velden[y][x].steen != null)
				return false;
		
		return true;
	}

}