import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;



class Veld extends StackPane
{
	int rij, kol;
	Steen steen;

	Rectangle steenOppervlak;
	Text txtNummer;


	Veld(int rij, int kol) 
	{
		this.rij = rij;
		this.kol = kol;
		steenOppervlak = new Rectangle(Rummikub.STEEN_BREEDTE, Rummikub.STEEN_HOOGTE);
		steenOppervlak.setFill(Color.ANTIQUEWHITE);
		steenOppervlak.setVisible(false);
		super.getChildren().add(steenOppervlak);

		txtNummer = new Text("");
		txtNummer.setFont(new Font("Arial Bold", 15));
		txtNummer.setVisible(false);
		super.getChildren().add(txtNummer);
	}


	
	void setSteen(Steen steen)
	{
		this.steen = steen;
		if (steen == null)
		{
			steenOppervlak.setVisible(false);
			txtNummer.setVisible(false);
		}
		else
		{
			steenOppervlak.setVisible(true);
			txtNummer.setFill(steen.joker? Color.BLACK : Steen.kleuren[steen.kleur]);
			txtNummer.setText(steen.joker? "*" : "" + steen.nummer);
			txtNummer.setVisible(true);

			steen.x = kol;
			steen.y = rij;
		}
	}
	
}