from dataclasses import dataclass

@dataclass
class Deelnemer:
	naam: str
	aantWedstr: int = 0
	aantGew: int = 0
	aantGel: int = 0
	aantVerl: int = 0
	aantPunt: int = 0
	aantDoelpunt: int = 0
	aantTegenDoelpunt: int = 0

	def __init__(self, naam):
		self.naam = naam

	def verwerkWedstrijd(self, score, teg_score):
		self.aantWedstr += 1
		self.aantDoelpunt += score
		self.aantTegenDoelpunt += teg_score
		if score > teg_score:
			self.aantGew += 1
			self.aantPunt += 3
		if score == teg_score:
			self.aantGel += 1
			self.aantPunt += 1
		if score < teg_score:
			self.aantVerl += 1	



def getDnr(naam):
	for dnr in deelnemers:
		if naam == dnr.naam:
			return dnr
	#creeer new deelnemer-object als deelnemer nog niet bestaat in de lijst.
	dnr = Deelnemer(naam)
	deelnemers.append(dnr)
	return dnr



def formatInt(value, aantDecimals): #opvullen met spaties. 
	#value is een niet-negatieve integer
		
	spaces = ''
	for d in range(1, aantDecimals):
		if (value < 10 ** d):
			spaces = spaces + ' '
	return spaces + str(value)

def formatIntSign(value, aantDecimals): #opvullen met spaties, en zet een +/-teken ervoor 	
	result = '' 
	for d in range(1, aantDecimals) :
		if abs(value) < 10 ** d:
			result += ' '
	if value > 0:
		result += '+'
	if value == 0:
		result += ' '
	result += str(value)
	return result
	


def printStandRegel(pos, dnr):
	if aantDeelnr < 10:
		result = str(pos)
	else:
		result = formatInt(pos, 2)
	result += '. '
	result += dnr.naam + ' '
	result += formatInt(dnr.aantWedstr, 2) + '   '
	result += formatInt(dnr.aantGew, 2) + ' '
	result += formatInt(dnr.aantGel, 2) + ' '
	result += formatInt(dnr.aantVerl, 2) + '   ' 
	result += formatInt(dnr.aantPunt, 3) + '  '
	result += formatIntSign(dnr.aantDoelpunt - dnr.aantTegenDoelpunt, 3) + '  '
	#	result += "+"
	result += formatInt(dnr.aantDoelpunt, 3) + ' -' + formatInt(dnr.aantTegenDoelpunt, 3)
	print(result)



deelnemers = []
with open('wedstrijden.txt') as f:
	lines = f.readlines()
for line in lines:
	if line == '':   #skip empty lines
		continue;		 
	dnr1 = getDnr(line[0:25])
	dnr2 = getDnr(line[26:51])
	score1 = int(line[52:55])
	score2 = int(line[58:61])
	dnr1.verwerkWedstrijd(score1, score2)
	dnr2.verwerkWedstrijd(score2, score1)		

aantDeelnr = len(deelnemers)
pos = 1
print()
print('                                               Pt')
print()
while len(deelnemers) > 0:  
	theBest = deelnemers[0]
	for dnr in deelnemers:
		if (dnr.aantPunt > theBest.aantPunt or 
			(dnr.aantPunt == theBest.aantPunt and   #niet volledig: aantal gespeelde wedstijden vergeten...
			dnr.aantDoelpunt - dnr.aantTegenDoelpunt > theBest.aantDoelpunt - theBest.aantTegenDoelpunt) or
			(dnr.aantPunt == theBest.aantPunt and 
			dnr.aantDoelpunt - dnr.aantTegenDoelpunt == theBest.aantDoelpunt - theBest.aantTegenDoelpunt and
			dnr.aantDoelpunt > theBest.aantDoelpunt)
		):	
			theBest = dnr
	
	printStandRegel(pos, theBest)

	#verwijder theBest uit de lijst met deelnemers, om de "next best" (the best of the rest) te vinden
	for d in range(0, len(deelnemers)):
		if deelnemers[d].naam == theBest.naam:
				del deelnemers[d]
				break
	pos = pos + 1

print()
