import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;



class BordVeld extends StackPane
{
	int status;
	char letter;
	
	final static int LEEG = 0, FOUT = 1, GOED = 2, ELDERS = 3;

	Rectangle goedVierkant;
	Circle eldersCirkel;
	Text txtLetter;

	

	BordVeld()
	{
		Rectangle achtergrond = new Rectangle(Bord.veldBreedte, Bord.veldBreedte);
		achtergrond.setStroke(Color.WHITE);
		achtergrond.setFill(Color.STEELBLUE);
		super.getChildren().add(achtergrond);

		goedVierkant = new Rectangle(Bord.veldBreedte, Bord.veldBreedte);	
		goedVierkant.setStroke(Color.WHITE);
		goedVierkant.setFill(Color.MAGENTA);
		goedVierkant.setVisible(false);
		super.getChildren().add(goedVierkant);
	
		eldersCirkel = new Circle(Bord.veldBreedte / 2, Color.KHAKI);
		eldersCirkel.setVisible(false);
		super.getChildren().add(eldersCirkel);
		
		txtLetter = new Text("");
		txtLetter.setFont(new Font("Arial Bold", 24));
		txtLetter.setFill(Color.WHITE);
		super.getChildren().add(txtLetter);
	}



	void setStatus(int newStatus)
	{
		status = newStatus;
		if (status == LEEG)
		{
			goedVierkant.setVisible(false);
			eldersCirkel.setVisible(false);
			txtLetter.setText("");
		}
		if (status == FOUT)
		{
			goedVierkant.setVisible(false);
			eldersCirkel.setVisible(false);
		}
		if (status == GOED)
		{
			goedVierkant.setVisible(true);
			eldersCirkel.setVisible(false);
		}
		if (status == ELDERS)
		{
			goedVierkant.setVisible(false);
			eldersCirkel.setVisible(true);
		}	
	}

	
	
	void setLetter(char letter)
	{
		this.letter = letter;
		txtLetter.setText("" + letter);
	}

}