import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;



class KaartVeld extends StackPane
{
	int rij, kol;
	int nummer;
	boolean weggestreept;
	
	Circle cirkel;
	Text txtNummer;

	
	KaartVeld(int rij, int kol)
	{
		this.rij = rij;
		this.kol = kol;
		this.nummer = nummer;
		
		cirkel = new Circle(Kaart.veldBreedte / 2, Color.CORNFLOWERBLUE);
		super.getChildren().add(cirkel);
	
		txtNummer = new Text("");
		txtNummer.setFont(new Font("Arial Bold", 24));
		txtNummer.setFill(Color.WHITE);
		super.getChildren().add(txtNummer);
		
	}


	
	void setNummer(int nummer)
	{
		this.nummer = nummer;
		txtNummer.setText("" + nummer);
	}



	void streepNummerWeg()
	{
		txtNummer.setVisible(false);
		cirkel.setFill(Color.YELLOW);
		weggestreept = true;
	}


	
	void reset()
	{
		weggestreept = false;
		txtNummer.setVisible(true);
		cirkel.setFill(Color.CORNFLOWERBLUE);
	}
	
}