import java.io.*;
import java.util.ArrayList;
import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Alert.AlertType;
import javafx.scene.control.ButtonType;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Color;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import java.util.Optional;



public class Lingo extends Application 
{
	final static int AANTAL_TE_SPELEN_WOORDEN = 10;
	
	Speler[] spelers;
	int adb_ind;
	Speler adb;
	boolean finale;
	int poging;
	String strGoedeWoord;
	char[] goedeWoord;
	boolean[] gegevenLetters;
	ArrayList<String> woordenLijst;
	int currWoord;		
	int jackpot;	

	AnchorPane rootPane;
	Bord bord;
	Text txtAdb;//aan de beurt
	Text txtJackpot;
	SpelerPane[] spelerPanes;
		


	@Override
	public void start(Stage stage) throws Exception 
	{
		rootPane = new AnchorPane();
		
		Scene scene = new Scene(rootPane, 1000, 700, Color.LIGHTGREY);
		stage.setTitle("Lingo");
		stage.setScene(scene);
		stage.show();

		leesWoordenLijst();

		spelers = new Speler[2];

		finale = false;
		
		for (int i = 0; i < 2; i++)
		{
			Speler speler = new Speler(this, i);
			spelers[i] = speler;

			Kaart kaart = new Kaart(i == 0);
			speler.kaart = kaart;
			AnchorPane.setLeftAnchor(kaart, 350.0);
			AnchorPane.setTopAnchor(kaart, 150.0);
			kaart.setVisible(false);
			rootPane.getChildren().add(kaart);
			kaart.nieuweKaart(false);
			
			nieuweBallen(i, kaart);
		}

		txtAdb = new Text("");
		AnchorPane.setLeftAnchor(txtAdb, 350.0);
		AnchorPane.setTopAnchor(txtAdb, 10.0); 
		rootPane.getChildren().add(txtAdb);

		spelerPanes = new SpelerPane[2];

		spelerPanes[0] = new SpelerPane(spelers[0]);
		AnchorPane.setLeftAnchor(spelerPanes[0], 150.0);
		AnchorPane.setTopAnchor(spelerPanes[0], 120.0);
		rootPane.getChildren().add(spelerPanes[0]);
		
		spelerPanes[1] = new SpelerPane(spelers[1]);
		AnchorPane.setLeftAnchor(spelerPanes[1], 800.0);
		AnchorPane.setTopAnchor(spelerPanes[1], 120.0);
		rootPane.getChildren().add(spelerPanes[1]);
				
		txtJackpot = new Text("");
		AnchorPane.setLeftAnchor(txtJackpot, 350.0);
		AnchorPane.setTopAnchor(txtJackpot, 70.0); 
		rootPane.getChildren().add(txtJackpot);

		bord = new Bord(this, 5);
		AnchorPane.setLeftAnchor(bord, 350.0);
		AnchorPane.setTopAnchor(bord, 150.0);
		bord.setVisible(false);
		rootPane.getChildren().add(bord);

		loadJackpot();
		setAdb(0);
		currWoord = -1;				
		nieuwWoord();
	}


	
	void setAdb(int adb_ind)
	{
		this.adb_ind = adb_ind;
		adb = spelers[adb_ind];
		alert("De beurt gaat naar " + adb.naam + ".");
		txtAdb.setText("Aan de beurt: " + adb.naam);
	}


	
	void nieuweBallen(int speler_ind, Kaart kaart)
	{
		Speler speler = spelers[speler_ind];
		speler.ballen = new ArrayList<Bal>();
		
		if (finale)
		{
			for (int k = 0; k < 5; k++)
				for (int r = 0; r < 5; r++)
				{	
					Bal bal = new Bal(Bal.BLAUW);
					bal.nummer = kaart.velden[k][r].nummer;
					speler.ballen.add(bal);
				}			
	
			speler.ballen.add(new Bal(Bal.GOUD));
		}
		else
		{
			for (int k = 0; k < 5; k++)
				for (int r = 0; r < 5; r++)
					if (!kaart.velden[k][r].weggestreept)
					{	
						Bal bal = new Bal(Bal.BLAUW);
						bal.nummer = kaart.velden[k][r].nummer;
						speler.ballen.add(bal);
					}			
	
			for (int j = 0; j < 3; j++)
				speler.ballen.add(new Bal(Bal.ROOD));
			for (int j = speler.aantGroeneBallen; j < 3; j++)
				speler.ballen.add(new Bal(Bal.GROEN));
		}		
	}



	void nieuwWoord()
	{
		currWoord++;
		int woordIndex = (int)(Math.random() * woordenLijst.size());
		strGoedeWoord = woordenLijst.get(woordIndex);
		goedeWoord = strGoedeWoord.toCharArray();
		bord.maakLeeg();
		bord.setVisible(true);
		gegevenLetters = new boolean[goedeWoord.length];
		gegevenLetters[0] = true;
		
		if (finale)  //dan krijgt de speler nog een (willekeurige) letter cadeau
		{
			int tweedeLetter = (int) (Math.random() * (goedeWoord.length - 1)) + 1;
			gegevenLetters[tweedeLetter] = true;	
		}
		
		poging = -1;
		beginNieuwePoging();
	}


	
	void beginNieuwePoging()
	{
		poging++;
		int rij = (poging > 4 ? 4 : poging);
		for (int i = 0; i < goedeWoord.length; i++)
			if (gegevenLetters[i])
			{
				bord.velden[rij][i].setLetter(goedeWoord[i]);
				bord.velden[rij][i].setStatus(BordVeld.GOED);
			}
		bord.tfRaadWoord.setText("");
		bord.tfRaadWoord.requestFocus();
	}



	void raad()
	{	
		String strRaadWoord = bord.tfRaadWoord.getText();
		char[] raadWoord = strRaadWoord.toUpperCase().toCharArray();
		boolean ongeldig = false;
		boolean goedGeraden = false;
		int rij = (poging > 4 ? 4 : poging);
				
		if (raadWoord.length != goedeWoord.length)
			ongeldig = true;
		else if (raadWoord[0] != goedeWoord[0])
			ongeldig = true;
		if (ongeldig)
		{
			alert("Ongeldige poging");
		}
		else
		{
			goedGeraden = true;
			for (int i = 0; i < goedeWoord.length; i++)
			{
				bord.velden[rij][i].setLetter(raadWoord[i]);
				if (raadWoord[i] == goedeWoord[i]) 
				{
					bord.velden[rij][i].setStatus(BordVeld.GOED);
					gegevenLetters[i] = true;
				}
				else
				{
					bord.velden[rij][i].setStatus(BordVeld.FOUT);
					goedGeraden = false;
				}
			}
			boolean[] referred = new boolean[goedeWoord.length];
			for (int i = 0; i < goedeWoord.length; i++)
				referred[i] = (bord.velden[rij][i].status == BordVeld.GOED);
			for (int i = 0; i < goedeWoord.length; i++)
			{
				if (bord.velden[rij][i].status != BordVeld.GOED)
					for (int j = 0; j < goedeWoord.length; j++)
					{	
						if (j == i || referred[j])
							continue;
						if (raadWoord[i] == goedeWoord[j])
						{
							bord.velden[rij][i].setStatus(BordVeld.ELDERS);
							referred[j] = true;
							break;
						}
					} 
			}			
		}	



		if (goedGeraden)
		{
			woordGeraden();
			return;
		}

		if (finale)
		{	
			if (poging < 4)
				beginNieuwePoging();
			else
				woordNietGeraden();
		}
		else
		{
			if (poging < 4)
			{	
				if (ongeldig)
				{
					setAdb(1 - adb_ind);
					addBonusLetter();
					beginNieuwePoging();
				}
				else
					beginNieuwePoging();
			}
			else if (poging == 4)
			{
				setAdb(1 - adb_ind);
				schuifWoordenOmhoog();
				addBonusLetter();
				beginNieuwePoging();
			}
			else //poging = 5
			{
				woordNietGeraden();
			}
		}

	}


	
	void woordGeraden()
	{
		alert(strGoedeWoord + " is goed!");
				
		if (finale)
			beginBallenTrekken(poging + 1);
		else
		{
			setScore(adb_ind, adb.score + 25);
			setJackpot(jackpot + 25);
//testing
saveJackpot();
			beginBallenTrekken(2);
		}
		
	}



	void woordNietGeraden()
	{
		schuifWoordenOmhoog();
		for (int i = 0; i < goedeWoord.length; i++)
		{
			bord.velden[4][i].setLetter(goedeWoord[i]);
			bord.velden[4][i].setStatus(BordVeld.GOED);
		}
		alert("Het goede woord was: " + strGoedeWoord + ".");
		
		if (finale)
			beginBallenTrekken(6);
		else
			if (currWoord == AANTAL_TE_SPELEN_WOORDEN - 1)
				einde1eronde();
			else
				nieuwWoord();
	}


	
	void beginBallenTrekken(int aantBallen)
	{
		bord.setVisible(false);
		adb.kaart.setVisible(true);	
		
		if (finale)
			ballenTrekkenFinale(aantBallen);
		else	
			ballenTrekken1eRonde();	

		//adb.kaart.setVisible(false);

		if (!finale)
			if (currWoord == AANTAL_TE_SPELEN_WOORDEN - 1)
				einde1eronde();
			else
				nieuwWoord();
				
	}



	void ballenTrekken1eRonde()
	{
		int aantGetrokkenBallen = 0;
		while (true)
		{
			int bal_ind = (int) (Math.random() * adb.ballen.size());
			Bal bal = adb.ballen.remove(bal_ind);	
			alert("Je hebt de volgende bal getrokken: " + bal);
			
			if (bal.type == Bal.BLAUW)
			{
				adb.kaart.streepNummerWeg(bal.nummer);
				
				if (adb.kaart.lingo())
				{
					alert("LINGO!");
					setScore(adb_ind, adb.score + 50);	
					adb.kaart.nieuweKaart(false);
					nieuweBallen(adb_ind, adb.kaart);
					adb.kaart.setVisible(false);
					setAdb(1 - adb_ind);
					break;
				}
				aantGetrokkenBallen++;
			}
			if (bal.type == Bal.ROOD)
			{
				adb.kaart.setVisible(false);
				setAdb(1 - adb_ind);
				break;
			}
			if (bal.type == Bal.GROEN)
			{
				adb.setAantGroeneBallen(adb.aantGroeneBallen + 1);
				if (adb.aantGroeneBallen == 3)
				{
					alert("Je hebt de jackpot gewonnen! " + jackpot + ",-");
					adb.jackpotScore += jackpot;
					setJackpot(0);
					saveJackpot();
					
					//doe de 3 groene ballen weer terug in de bak
					adb.setAantGroeneBallen(0);
					for (int j = 0; j < 3; j++)
						adb.ballen.add(new Bal(Bal.GROEN));
				}
			}
			
			if (aantGetrokkenBallen == 2)
			{
				adb.kaart.setVisible(false);
				break;
			}
		}	
		
	}	



	void ballenTrekkenFinale(int aantBallen)
	{
		int aantGetrokkenBallen = 0;
		
		while (true)
		{	
			int bal_ind = (int) (Math.random() * adb.ballen.size());
			Bal bal = adb.ballen.remove(bal_ind);	
			alert("Je hebt de volgende bal getrokken: " + bal);
			
			if (bal.type == Bal.BLAUW)
			{
				adb.kaart.streepNummerWeg(bal.nummer);
				
				if (adb.kaart.lingo())
				{
					alert("LINGO...");
					setScore(adb_ind, 0);
					eindeFinale();
					return;		
				}
				aantGetrokkenBallen++;
			}
			if (bal.type == Bal.GOUD)
				break;
			if (aantGetrokkenBallen == aantBallen)
				break;	
		}
		
		
		setScore(adb_ind, adb.score * 2);

		if (currWoord == 4)
		{
			alert("Je hebt het einde gehaald!");
			eindeFinale();
			return;
		}
		
		Alert alert = new Alert(AlertType.CONFIRMATION, "Wil je doorspelen?");
		alert.setX(500.0);
		alert.setY(600.0);
		Optional<ButtonType> result = alert.showAndWait();
 		boolean doorspelen = (result.isPresent() && result.get() == ButtonType.OK);		
		if (doorspelen)
		{	
			adb.kaart.setVisible(false);
			nieuwWoord();
		}
		else
			eindeFinale();
	}


	
	void einde1eronde()
	{
		
		saveJackpot();
		
		alert("De 1e ronde is afgelopen, we gaan naar de finale!");
		
		int winnaar = -1;
		if (spelers[0].score == spelers[1].score)
			winnaar = (int) (Math.random() * 2);
		if (spelers[0].score > spelers[1].score)
			winnaar = 0;
		if (spelers[1].score > spelers[0].score)
			winnaar = 1;
		
		spelerPanes[1 - winnaar].setVisible(false);
		txtJackpot.setVisible(false);
		finale = true;
		setAdb(winnaar);
		adb.kaart.nieuweKaart(true);
		nieuweBallen(adb_ind, adb.kaart);
		currWoord = -1;
		nieuwWoord();
	}



	void eindeFinale()
	{	
		HighScores highScores = new HighScores();
		highScores.load();
		highScores.addScore(spelers[0].score + spelers[0].jackpotScore);
		highScores.addScore(spelers[1].score + spelers[1].jackpotScore);
		highScores.print();
		highScores.save();
	}



	void schuifWoordenOmhoog()
	{
		for (int r = 0; r < 4; r++)
			for (int i = 0; i < goedeWoord.length; i++)
			{
				bord.velden[r][i].setLetter(bord.velden[r + 1][i].letter);
				bord.velden[r][i].setStatus(bord.velden[r + 1][i].status);
			}
		//maak (voor de volledigheid/zekerheid) de onderste rij leeg
		for (int i = 0; i < goedeWoord.length; i++)
			bord.velden[4][i].setStatus(BordVeld.LEEG);
	}
	


	void addBonusLetter()
	{
		//geen bonusletter als dit de laatst overgebleven letter is 
		int aantGegevenLetters = 0;
		for (int i = 0; i < gegevenLetters.length; i++)
			if (gegevenLetters[i])
				aantGegevenLetters++;
		if (aantGegevenLetters >= goedeWoord.length - 1)
			return;

		//de eerste letter die nog niet gegeven is, wordt de bonusletter
		for (int i = 0; i < gegevenLetters.length; i++)
			if (!gegevenLetters[i])
			{
				gegevenLetters[i] = true;
				break;
			}		
	}



	void setScore(int speler_ind, int score)
	{
		spelers[speler_ind].score = score;
		spelerPanes[speler_ind].txtScore.setText("" + score);
	}


	
	void setJackpot(int nwJackpotBedrag)
	{
		jackpot = nwJackpotBedrag;
		txtJackpot.setText("Jackpot: " + nwJackpotBedrag);
	}



	void loadJackpot()
	{	
		try
		{
			FileInputStream fis = new FileInputStream("jackpot");
    			DataInputStream in = new DataInputStream(new BufferedInputStream(fis));
			setJackpot(in.readInt());
			in.close();
    		}
		catch (IOException ioExc)
		{	
			setJackpot(0);
		}
	}



	void saveJackpot()
	{
		try 
		{
			FileOutputStream fos = new FileOutputStream("jackpot");
			DataOutputStream out = new DataOutputStream(new BufferedOutputStream(fos));
			out.writeInt(jackpot);
			out.close();			
		}
		catch (IOException ioExc)
		{	
		}

	}



	void leesWoordenLijst()
	{
		woordenLijst = new ArrayList<String>();
		try { 
			BufferedReader reader = new BufferedReader(new FileReader("woordenlijst.txt"));
			String line;
			while ((line = reader.readLine()) != null)
				woordenLijst.add(line.toUpperCase()); 			
		}
		catch (Exception exc)
		{
			alert("Fout bij het lezen van het woordenlijstbestand.");
			woordenLijst = new ArrayList<String>();
			woordenLijst.add("ACTIE");
			woordenLijst.add("AFVAL");
			woordenLijst.add("ALLES");
			woordenLijst.add("APART");
			woordenLijst.add("APPEL");
		}
	}


/*
	void alert(String message)
	{
		(new Alert(AlertType.INFORMATION, message)).showAndWait();
	}
*/

void alert(String message)
	{
		Alert alert = new Alert(AlertType.INFORMATION, message);
		alert.setX(500.0);
		alert.setY(600.0);
		alert.showAndWait();
	}


	static void sleep(int milliSecs)
	{	
		long startTijd = System.currentTimeMillis();
		long tijd;
		do {
			tijd = System.currentTimeMillis();
		}
		while (tijd - startTijd < milliSecs);
	}



	public static void main(String[] args) 
	{
		launch(args);
	}

}